/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.progress;

import fr.devsylone.fallenkingdom.display.progress.ActionBarProgress;
import fr.devsylone.fallenkingdom.display.progress.BossBarProgress;
import fr.devsylone.fallenkingdom.display.progress.HologramProgress;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ProgressBar {
    public static final ProgressBar EMPTY = new ProgressBar(){

        @Override
        public void progress(@NotNull Player player, @NotNull Location location, double progress) {
        }

        @Override
        public void remove(@NotNull Player player) {
        }
    };

    public void progress(@NotNull Player var1, @NotNull Location var2, @Range(from=0L, to=1L) double var3);

    public void remove(@NotNull Player var1);

    @NotNull
    public static String percent(double progress) {
        return String.valueOf((int)(progress * 100.0));
    }

    @FunctionalInterface
    public static interface Provider {
        public static final Provider EMPTY = (player, location) -> EMPTY;

        @NotNull
        public ProgressBar init(@NotNull Player var1, @NotNull Location var2);

        default public void save(@NotNull ConfigurationSection config) {
        }

        @NotNull
        public static Provider fromConfig(@Nullable ConfigurationSection config) {
            if (config == null) {
                return new HologramProgress.ProviderImpl((ConfigurationSection)new MemoryConfiguration());
            }
            String type = config.getString("type", "hologram");
            if ("actionbar".equals(type)) {
                return new ActionBarProgress.ProviderImpl(config);
            }
            if ("bossbar".equals(type)) {
                return new BossBarProgress.ProviderImpl(config);
            }
            return new HologramProgress.ProviderImpl(config);
        }
    }
}

