/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.sound;

import fr.devsylone.fallenkingdom.display.sound.LegacySoundPlayer;
import fr.devsylone.fallenkingdom.display.sound.ModernSoundPlayer;
import fr.devsylone.fallenkingdom.version.Version;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface SoundPlayer {
    public static final SoundPlayer EMPTY = player -> {};
    public static final boolean HAS_CATEGORY = Version.classExists("org.bukkit.SoundCategory");

    public void play(@NotNull Player var1);

    default public void save(@NotNull ConfigurationSection config) {
    }

    @NotNull
    public static SoundPlayer fromConfig(@Nullable ConfigurationSection config, @NotNull String defaultSound) {
        if (config == null) {
            return SoundPlayer.create(defaultSound);
        }
        if (config.getString("sound", "").isEmpty() || Double.compare(config.getDouble("volume"), 0.0) <= 0) {
            return EMPTY;
        }
        return SoundPlayer.create(config);
    }

    @NotNull
    public static SoundPlayer create(@NotNull ConfigurationSection config) {
        return HAS_CATEGORY ? new ModernSoundPlayer(config) : new LegacySoundPlayer(config);
    }

    @NotNull
    public static SoundPlayer create(@NotNull String sound) {
        return HAS_CATEGORY ? new ModernSoundPlayer(sound, 0.8f, 1.0f) : new LegacySoundPlayer(sound, 0.8f, 1.0f);
    }

    @NotNull
    public static String deathSound() {
        if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
            return "entity.wither.spawn";
        }
        return "mob.wither.spawn";
    }

    @NotNull
    public static String gameStartSound() {
        if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
            return "entity.generic.explode";
        }
        return "random.explode";
    }

    @NotNull
    public static String eliminationSound() {
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            return "entity.ender_dragon.death";
        }
        if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
            return "entity.enderdragon.death";
        }
        return "mob.enderdragon.end";
    }

    @NotNull
    public static String eventSound() {
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            return "entity.ender_dragon.growl";
        }
        if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
            return "entity.enderdragon.growl";
        }
        return "mob.enderdragon.growl";
    }
}

