/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.tick;

import fr.devsylone.fallenkingdom.display.tick.TickFormatter;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class CycleTickFormatter
extends TickFormatter {
    public static final int HOURS_PER_DAY = 24;
    public static final int TICKS_PER_DAY_NIGHT_CYCLE = 24000;
    private final int startTimeDay;
    private final int ticksPerGameHour;
    private final float dayTickFactor;
    protected final boolean twelveHours;
    protected static final String START_TIME_DAY = "start-time-day";
    protected static final String TWELVE_HOURS = "twelve-hours";

    public CycleTickFormatter() {
        this(24000, false, false, 6);
    }

    public CycleTickFormatter(int dayDuration, boolean twelveHours, boolean countdown, int startTimeDay) {
        super(dayDuration, countdown);
        this.twelveHours = twelveHours;
        this.startTimeDay = startTimeDay;
        this.ticksPerGameHour = dayDuration / 24;
        this.dayTickFactor = (float)dayDuration / 24000.0f;
    }

    public CycleTickFormatter(@NotNull ConfigurationSection config) {
        this(24000, config.getBoolean(TWELVE_HOURS), config.getBoolean("countdown"), config.getInt(START_TIME_DAY, 6));
    }

    @Override
    public int extractHours(int ticks) {
        int dayTicks = this.complementThenMod(ticks, this.dayDuration);
        return dayTicks / this.ticksPerGameHour + this.startTimeDay;
    }

    @Override
    @NotNull
    public String formatHours(int ticks) {
        int hours = this.extractHours(ticks) % 24;
        if (this.twelveHours) {
            String period = hours < 12 ? "am" : "pm";
            int hour = hours % 12;
            if (hour == 0) {
                return "12" + period;
            }
            return hour + period;
        }
        return CycleTickFormatter.twoDigits(hours);
    }

    @Override
    public int extractMinutes(int ticks) {
        int hourTicks = this.complementThenMod(ticks, this.ticksPerGameHour);
        return hourTicks * 60 / this.ticksPerGameHour;
    }

    @Override
    public long worldTime(int days, int ticks) {
        return (long)days * 24000L + (long)((float)ticks / this.dayTickFactor);
    }

    @Override
    public int timeFromWorld(long worldTime) {
        return (int)((float)(worldTime % 24000L) * this.dayTickFactor);
    }

    @Override
    public int dayFromWorld(long worldTime) {
        return (int)(worldTime / 24000L);
    }

    @Override
    @NotNull
    public TickFormatter withDayDuration(int dayDuration) {
        return new CycleTickFormatter(dayDuration, this.twelveHours, this.countdown, this.startTimeDay);
    }

    @Override
    public void save(@NotNull ConfigurationSection config) {
        super.save(config);
        config.set(TWELVE_HOURS, (Object)this.twelveHours);
        config.set(START_TIME_DAY, (Object)this.startTimeDay);
        config.set("type", (Object)"cycle");
    }
}

