/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.tick;

import fr.devsylone.fallenkingdom.display.tick.CycleTickFormatter;
import fr.devsylone.fallenkingdom.display.tick.TimerTickFormatter;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public abstract class TickFormatter {
    protected final int dayDuration;
    protected final boolean countdown;
    protected static final String TYPE = "type";
    protected static final String COUNTDOWN = "countdown";

    public TickFormatter(int dayDuration, boolean countdown) {
        this.dayDuration = dayDuration;
        this.countdown = countdown;
    }

    protected TickFormatter(@NotNull ConfigurationSection config) {
        this(24000, config.getBoolean(COUNTDOWN));
    }

    public abstract int extractHours(int var1);

    @NotNull
    public String formatHours(int ticks) {
        return TickFormatter.twoDigits(this.extractHours(ticks) % 24);
    }

    public abstract @Range(from=0L, to=59L) int extractMinutes(int var1);

    @NotNull
    public String formatMinutes(int ticks) {
        return TickFormatter.twoDigits(this.extractMinutes(ticks));
    }

    public abstract long worldTime(int var1, int var2);

    public abstract int timeFromWorld(long var1);

    public abstract int dayFromWorld(long var1);

    public int dayDuration() {
        return this.dayDuration;
    }

    @Contract(value="_ -> new")
    @NotNull
    public abstract TickFormatter withDayDuration(int var1);

    protected int complementThenMod(int ticks, int mod) {
        int r = ticks % mod;
        return this.countdown ? mod - r : r;
    }

    @NotNull
    public static String twoDigits(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    @NotNull
    public static TickFormatter fromConfig(@NotNull ConfigurationSection config) {
        if (config.getString(TYPE, "cycle").equals("timer")) {
            return new TimerTickFormatter(config);
        }
        return new CycleTickFormatter(config);
    }

    @MustBeInvokedByOverriders
    public void save(@NotNull ConfigurationSection config) {
        config.set(COUNTDOWN, (Object)this.countdown);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "dayDuration=" + this.dayDuration + ", countdown=" + this.countdown + '}';
    }
}

