/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.tick;

import fr.devsylone.fallenkingdom.display.tick.TickFormatter;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class TimerTickFormatter
extends TickFormatter {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TICKS_PER_MINUTE = 1200;

    public TimerTickFormatter(int dayDuration, boolean countdown) {
        super(dayDuration, countdown);
    }

    protected TimerTickFormatter(@NotNull ConfigurationSection config) {
        super(config);
    }

    @Override
    public int extractHours(int ticks) {
        int dayTicks = this.complementThenMod(ticks, this.dayDuration);
        return dayTicks / 1200;
    }

    @Override
    public int extractMinutes(int ticks) {
        return this.complementThenMod(ticks, 1200) / 20;
    }

    @Override
    public long worldTime(int days, int ticks) {
        return (long)days * (long)this.dayDuration + (long)ticks;
    }

    @Override
    public int timeFromWorld(long worldTime) {
        return (int)(worldTime % (long)this.dayDuration);
    }

    @Override
    public int dayFromWorld(long worldTime) {
        return (int)(worldTime / (long)this.dayDuration);
    }

    @Override
    @NotNull
    public TickFormatter withDayDuration(int dayDuration) {
        return new TimerTickFormatter(dayDuration, this.countdown);
    }

    @Override
    public void save(@NotNull ConfigurationSection config) {
        super.save(config);
        config.set("type", (Object)"timer");
    }
}

