/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.game;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.game.CaptureRunnable;
import fr.devsylone.fallenkingdom.version.title.TitleSender;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.ITeam;
import fr.devsylone.fkpi.teams.ChestsRoom;
import java.util.LinkedList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestRoomRunnable
extends BukkitRunnable {
    public static final int PERIOD_TICKS = 5;
    private final ChestsRoom chestsRoom;
    private final ITeam assailants;
    private final ITeam defenders;
    private int elapsedRuns;

    public ChestRoomRunnable(ChestsRoom chestsRoom, ITeam assailants, ITeam defenders) {
        this.chestsRoom = chestsRoom;
        this.assailants = assailants;
        this.defenders = defenders;
    }

    public void run() {
        int captureTime = FkPI.getInstance().getChestsRoomsManager().getCaptureTime() * 4;
        if (Fk.getInstance().getGame().isPaused()) {
            return;
        }
        if (++this.elapsedRuns == captureTime) {
            CaptureRunnable.run(this.defenders, this.assailants);
            this.chestsRoom.markAsCaptured();
            this.cancel();
        } else {
            LinkedList<Player> outsidePlayers = new LinkedList<Player>();
            for (UUID uuid : this.chestsRoom.getEnemiesInside()) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                if (!this.chestsRoom.contains(player.getLocation()) || player.isDead()) {
                    outsidePlayers.add(player);
                }
                int progressionPercentage = this.elapsedRuns * 100 / captureTime;
                TitleSender.INSTANCE.sendTitle(player, "", "\u00a7b" + progressionPercentage + "%", 0, 20, 20);
            }
            for (Player player : outsidePlayers) {
                this.chestsRoom.removeEnemyInside(player);
            }
        }
    }
}

