/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.game;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.display.tick.CycleTickFormatter;
import fr.devsylone.fallenkingdom.display.tick.TickFormatter;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.game.GameRunnable;
import fr.devsylone.fallenkingdom.game.TeleportTask;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.event.DayEvent;
import fr.devsylone.fkpi.api.event.GameEvent;
import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Game
implements Saveable {
    private static final List<Rule<?>> OBSERVED_RULES = Arrays.asList(Rule.PVP_CAP, Rule.TNT_CAP, Rule.NETHER_CAP, Rule.END_CAP);
    protected GameState state = GameState.BEFORE_STARTING;
    protected int day = 0;
    protected int time = FkPI.getInstance().getRulesManager().getRule(Rule.DAY_DURATION) - 10;
    protected TickFormatter timeFormat = null;
    protected GameRunnable task = null;
    protected boolean assaultsEnabled = false;
    protected boolean pvpEnabled = false;
    protected boolean netherEnabled = false;
    protected boolean endEnabled = false;

    @NotNull
    public GameState getState() {
        return this.state;
    }

    public boolean setState(GameState state) {
        if (this.state == state) {
            return false;
        }
        switch (state.ordinal()) {
            case 3: {
                Bukkit.getPluginManager().callEvent((Event)new GameEvent(GameEvent.Type.PAUSE_EVENT));
                break;
            }
            case 2: {
                if (this.state == GameState.STARTING) {
                    Bukkit.getPluginManager().callEvent((Event)new GameEvent(GameEvent.Type.START_EVENT));
                    break;
                }
                Bukkit.getPluginManager().callEvent((Event)new GameEvent(GameEvent.Type.RESUME_EVENT));
            }
        }
        this.state = state;
        return true;
    }

    public int getDay() {
        return this.day;
    }

    public int getTime() {
        return this.time;
    }

    public TickFormatter getTimeFormat() {
        return this.timeFormat;
    }

    public boolean isAssaultsEnabled() {
        return this.assaultsEnabled;
    }

    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    public boolean isEndEnabled() {
        return this.endEnabled;
    }

    public boolean isNetherEnabled() {
        return this.netherEnabled;
    }

    public void startTimer() {
        if (this.task != null) {
            throw new IllegalStateException("Main timer already running");
        }
        if (this.hasStarted()) {
            Fk.getInstance().getTipsManager().cancelBroadcasts();
        }
        this.task = new GameRunnable(this);
        this.task.runTaskTimer((Plugin)Fk.getInstance(), 1L, 1L);
    }

    public void stopTimer() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
    }

    public void stop() {
        this.stopTimer();
        this.setState(GameState.BEFORE_STARTING);
        this.day = 0;
        this.time = FkPI.getInstance().getRulesManager().getRule(Rule.DAY_DURATION) - 10;
        this.assaultsEnabled = false;
        this.pvpEnabled = false;
        this.netherEnabled = false;
        this.endEnabled = false;
    }

    public <T> void onRuleChange(RuleChangeEvent<T> event) {
        if (this.updateCap(event.getRule()) != null) {
            this.playEventSound();
            Fk.getInstance().getDisplayService().updateAll(new PlaceHolder[0]);
        }
    }

    void syncCaps() {
        this.pvpEnabled = FkPI.getInstance().getRulesManager().getRule(Rule.PVP_CAP) <= this.day;
        this.assaultsEnabled = FkPI.getInstance().getRulesManager().getRule(Rule.TNT_CAP) <= this.day;
        this.netherEnabled = FkPI.getInstance().getRulesManager().getRule(Rule.NETHER_CAP) <= this.day;
        this.endEnabled = FkPI.getInstance().getRulesManager().getRule(Rule.END_CAP) <= this.day;
    }

    @Override
    public void load(ConfigurationSection config) {
        int savedDay = config.getInt("Day");
        int savedTime = config.getInt("Time");
        if (savedDay < 0) {
            Fk.getInstance().getLogger().severe("Invalid game day read from config: " + savedDay);
        }
        if (savedTime < 0) {
            Fk.getInstance().getLogger().severe("Invalid game time read from config: " + savedTime);
        }
        this.day = Math.max(0, savedDay);
        this.time = Math.max(0, savedTime);
        this.state = ConfigHelper.enumValueOf(GameState.class, config.getString("State"), this.day > 1 ? GameState.STARTED : GameState.BEFORE_STARTING);
        if (this.isPreStart() && this.day != 0) {
            Fk.getInstance().getLogger().severe("The game has not started and is on day " + savedDay + " at the same time.");
            this.state = GameState.STARTED;
        }
        this.syncCaps();
        this.updateDayDuration();
        switch (this.state.ordinal()) {
            case 1: {
                this.state = GameState.BEFORE_STARTING;
                this.start();
                break;
            }
            case 3: {
                if (!FkPI.getInstance().getRulesManager().getRule(Rule.DEEP_PAUSE).booleanValue()) break;
                Fk.getInstance().getDeepPauseManager().removeAIs();
                Fk.getInstance().getDeepPauseManager().protectDespawnItems();
                break;
            }
            case 2: {
                this.startTimer();
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("State", (Object)this.state.name());
        config.set("Day", (Object)this.day);
        config.set("Time", (Object)this.time);
    }

    public void start() {
        if (this.hasStarted()) {
            throw new FkLightException(Messages.CMD_ERROR_GAME_ALREADY_STARTED);
        }
        this.setState(GameState.STARTING);
        int time = 0;
        this.broadcastStartIn(30);
        this.delayedRunnable(() -> Fk.broadcast(Messages.BROADCAST_PREGAME_RULES.getMessage()), time += 5);
        this.delayedRunnable(() -> this.broadcastStartIn(20), time += 5);
        this.delayedRunnable(() -> Fk.broadcast(Messages.BROADCAST_PREGAME_TEAMS.getMessage()), time += 5);
        this.delayedRunnable(() -> this.broadcastStartIn(10), time += 5);
        Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), () -> {
            for (int i = 5; i > 0; --i) {
                int a = i;
                Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), () -> this.broadcastTpIn(6 - a), (long)(i * 20));
            }
        }, (long)(time += 5) * 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), () -> {
            long delayTeleportByTeam = 0L;
            for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
                Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), (Runnable)new TeleportTask(team), delayTeleportByTeam);
                delayTeleportByTeam += (long)(team.getPlayers().size() * 4);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), () -> {
                this.updateDayDuration();
                for (World w : Bukkit.getWorlds()) {
                    if (!Fk.getInstance().getWorldManager().isAffected(w)) continue;
                    w.setFullTime(this.getExceptedWorldTime());
                }
                Fk.broadcast(Messages.BROADCAST_START.getMessage());
                this.setState(GameState.STARTED);
                this.startTimer();
            }, delayTeleportByTeam + 5L);
        }, (long)(time += 6) * 20L);
    }

    private void delayedRunnable(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)Fk.getInstance(), runnable, delay * 20L);
    }

    private void broadcastStartIn(int time) {
        Fk.broadcast(Messages.BROADCAST_PREGAME_START.getMessage().replace("%time%", String.valueOf(time)));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), FkSound.NOTE_PLING.key(), 1.0f, 1.0f);
        }
    }

    private void broadcastTpIn(int time) {
        Fk.broadcast(Messages.BROADCAST_PREGAME_TP.getMessage().replace("%time%", String.valueOf(time)).replace("%unit%", Messages.Unit.SECONDS.tl(time)));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), FkSound.NOTE_BASS.key(), 1.0f, 1.0f);
        }
    }

    public long getExceptedWorldTime() {
        if (FkPI.getInstance().getRulesManager().getRule(Rule.ETERNAL_DAY).booleanValue()) {
            return 6000L;
        }
        return this.timeFormat.worldTime(this.day, this.time);
    }

    public void updateDayDuration() {
        int dayDuration = FkPI.getInstance().getRulesManager().getRule(Rule.DAY_DURATION);
        if (dayDuration < 1200) {
            FkPI.getInstance().getRulesManager().setRule(Rule.DAY_DURATION, 24000);
            dayDuration = 24000;
        }
        if (this.timeFormat == null) {
            this.timeFormat = new CycleTickFormatter(dayDuration, false, false, 6);
            return;
        }
        long previousTime = this.timeFormat.worldTime(this.day, this.time);
        this.timeFormat = this.timeFormat.withDayDuration(dayDuration);
        this.time = this.timeFormat.timeFromWorld(previousTime);
        this.day = this.timeFormat.dayFromWorld(previousTime);
    }

    public void updateDayDuration(@NotNull GlobalDisplayService displayService) {
        if (this.timeFormat == null) {
            this.timeFormat = displayService.baseTickFormatter();
            return;
        }
        this.timeFormat = displayService.configureTickFormatter(this.timeFormat.dayDuration());
    }

    public String getFormattedTime() {
        return this.getHour() + 'h' + this.getMinute();
    }

    public String getHour() {
        if (this.day == 0) {
            return "--";
        }
        return this.timeFormat.formatHours(this.time);
    }

    public String getMinute() {
        if (this.day == 0) {
            return "--";
        }
        return this.timeFormat.formatMinutes(this.time);
    }

    public boolean isPreStart() {
        return this.state == GameState.BEFORE_STARTING;
    }

    public boolean hasStarted() {
        return this.state != GameState.BEFORE_STARTING;
    }

    public boolean isPaused() {
        return this.state == GameState.PAUSE;
    }

    @Nullable
    <T> DayEvent updateCap(Rule<T> cap) {
        DayEvent event = null;
        if (Rule.PVP_CAP.equals(cap)) {
            boolean hasPvp;
            boolean bl = hasPvp = FkPI.getInstance().getRulesManager().getRule(Rule.PVP_CAP) <= this.day;
            if (hasPvp != this.pvpEnabled) {
                this.pvpEnabled = hasPvp;
                event = new DayEvent(DayEvent.Type.PVP_ENABLED, this.day, Messages.BROADCAST_DAY_PVP.getMessage());
            }
        } else if (Rule.TNT_CAP.equals(cap)) {
            boolean hasAssaults;
            boolean bl = hasAssaults = FkPI.getInstance().getRulesManager().getRule(Rule.TNT_CAP) <= this.day;
            if (hasAssaults != this.assaultsEnabled) {
                this.assaultsEnabled = hasAssaults;
                event = new DayEvent(DayEvent.Type.TNT_ENABLED, this.day, Messages.BROADCAST_DAY_ASSAULT.getMessage());
            }
        } else if (Rule.NETHER_CAP.equals(cap)) {
            boolean hasNether;
            boolean bl = hasNether = FkPI.getInstance().getRulesManager().getRule(Rule.NETHER_CAP) <= this.day;
            if (hasNether != this.netherEnabled) {
                this.netherEnabled = hasNether;
                event = new DayEvent(DayEvent.Type.NETHER_ENABLED, this.day, Messages.BROADCAST_DAY_NETHER.getMessage());
                Fk.getInstance().getPortalsManager().enablePortals();
            }
        } else if (Rule.END_CAP.equals(cap)) {
            boolean hasEnd;
            boolean bl = hasEnd = FkPI.getInstance().getRulesManager().getRule(Rule.END_CAP) <= this.day;
            if (hasEnd != this.endEnabled) {
                this.endEnabled = true;
                event = new DayEvent(DayEvent.Type.END_ENABLED, this.day, Messages.BROADCAST_DAY_END.getMessage());
            }
        }
        if (event != null) {
            Bukkit.getPluginManager().callEvent(event);
            if (event.getMessage() != null) {
                Fk.broadcast(event.getMessage());
            }
        }
        return event;
    }

    boolean updateCaps() {
        boolean changed = false;
        for (Rule<?> rule : OBSERVED_RULES) {
            changed |= this.updateCap(rule) != null;
        }
        if (changed) {
            this.playEventSound();
        }
        return changed;
    }

    private void playEventSound() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            Fk.getInstance().getDisplayService().playEventSound(player);
        }
    }

    public static enum GameState {
        BEFORE_STARTING,
        STARTING,
        STARTED,
        PAUSE;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String asString() {
            return this.name;
        }
    }
}

