/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.game;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.game.gamescommands.Pause;
import fr.devsylone.fallenkingdom.game.Game;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.event.DayEvent;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.CrystalCore;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;

class GameRunnable
extends BukkitRunnable {
    protected final Game game;
    private int lastMinutes;

    GameRunnable(Game game) {
        this.game = game;
        game.updateDayDuration();
        for (World world : Bukkit.getWorlds()) {
            if (!Fk.getInstance().getWorldManager().isAffected(world)) continue;
            world.setFullTime(game.getExceptedWorldTime());
        }
    }

    public void run() {
        int minutes;
        if (this.game.state != Game.GameState.STARTED) {
            Fk.getInstance().getLogger().warning("Game is not running. Cancelling game task.");
            this.game.task = null;
            this.cancel();
            return;
        }
        ++this.game.time;
        this.updateWorldTime();
        if (this.game.time >= this.game.timeFormat.dayDuration()) {
            this.incrementDay();
        }
        if ((minutes = this.game.timeFormat.extractMinutes(this.game.time)) != this.lastMinutes) {
            Fk.getInstance().getDisplayService().updateAll(PlaceHolder.DAY, PlaceHolder.HOUR, PlaceHolder.MINUTE);
            this.lastMinutes = minutes;
        }
        this.healCrystals();
    }

    protected void updateWorldTime() {
        long worldTime = this.game.getExceptedWorldTime();
        for (World w : Bukkit.getWorlds()) {
            if (!Fk.getInstance().getWorldManager().isAffected(w)) continue;
            if (w.getEnvironment() == World.Environment.NORMAL && Math.abs(w.getFullTime() - worldTime) > 32L && this.game.day != 0) {
                Fk.getInstance().getLogger().info(Messages.CONSOLE_ADJUSTMENT_GAME_TIME.getMessage());
                long fullTime = w.getFullTime();
                long day = this.game.timeFormat.dayFromWorld(fullTime);
                this.game.time = this.game.timeFormat.timeFromWorld(fullTime) % this.game.timeFormat.dayDuration();
                if (day > 0L) {
                    this.game.day = this.game.timeFormat.dayFromWorld(fullTime);
                    this.game.syncCaps();
                    Fk.getInstance().getDisplayService().updateAll(new PlaceHolder[0]);
                }
                worldTime = this.game.getExceptedWorldTime();
            }
            w.setFullTime(worldTime);
        }
        if (this.game.time == this.game.timeFormat.dayDuration() - this.game.timeFormat.dayDuration() / 24) {
            Fk.broadcast(Messages.BROADCAST_SUN_WILL_RISE.getMessage());
        }
    }

    protected void incrementDay() {
        ++this.game.day;
        this.game.time = 0;
        DayEvent dayEvent = new DayEvent(DayEvent.Type.NEW_DAY, this.game.day, Messages.BROADCAST_DAY.getMessage().replace("%day%", String.valueOf(this.game.day)));
        Bukkit.getPluginManager().callEvent((Event)dayEvent);
        Fk.broadcast(dayEvent.getMessage());
        if (Fk.getInstance().getConfig().getBoolean("enable-mcfunction-support", false)) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"function fallenkingdom:newday");
        }
        if (FkPI.getInstance().getRulesManager().getRule(Rule.AUTO_PAUSE).doAfterDay() && this.game.day > 1) {
            Fk.getInstance().getCommandManager().search(Pause.class).orElseThrow(RuntimeException::new).execute(Fk.getInstance(), (CommandSender)Bukkit.getConsoleSender(), Collections.emptyList(), "fk");
        }
        if (this.game.updateCaps()) {
            Fk.getInstance().getDisplayService().updateAll(new PlaceHolder[0]);
        }
        this.updateLockedChests();
    }

    private void updateLockedChests() {
        for (LockedChest chest : Fk.getInstance().getFkPI().getLockedChestsManager().getChests()) {
            if (chest.getUnlockDay() != this.game.day) continue;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!chest.hasAccess(player)) continue;
                ChatUtils.sendMessage((CommandSender)player, Messages.BROADCAST_DAY_CHEST.getMessage().replace("%name%", chest.getName()).replace("%x%", String.valueOf(chest.getLocation().getBlockX())).replace("%y%", String.valueOf(chest.getLocation().getBlockY())).replace("%z%", String.valueOf(chest.getLocation().getBlockZ())));
                player.playSound(player.getLocation(), FkSound.ENDERMAN_TELEPORT.key(), 1.0f, 1.0f);
            }
        }
    }

    protected void healCrystals() {
        int ticksInMinute = this.game.time % 1200;
        for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
            Nexus nexus;
            Base base = team.getBase();
            if (base == null || !((nexus = base.getNexus()) instanceof CrystalCore)) continue;
            CrystalCore core = (CrystalCore)nexus;
            boolean anyEnemy = false;
            int allyCount = 0;
            for (Player player : core.getPlayersInside()) {
                Team playerTeam = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
                if (playerTeam == null) continue;
                if (playerTeam.equals(team)) {
                    ++allyCount;
                    continue;
                }
                anyEnemy = true;
            }
            if (anyEnemy || allyCount == 0) continue;
            int previousGain = FkPI.getInstance().getChestsRoomsManager().getRegenerationForTicks(ticksInMinute - 1, --allyCount);
            int currentGain = FkPI.getInstance().getChestsRoomsManager().getRegenerationForTicks(ticksInMinute, allyCount);
            int gain = currentGain - previousGain;
            if (gain <= 0) continue;
            core.heal(gain);
        }
    }
}

