/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.listeners.block;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Team;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.jetbrains.annotations.NotNull;

public class BucketListener
implements Listener {
    private final Fk plugin;

    public BucketListener(@NotNull Fk plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void event(PlayerBucketEmptyEvent event) {
        this.onBucket((PlayerBucketEvent)event, Messages.PLAYER_PLACE_WATER_NEXT);
    }

    @EventHandler
    public void onFill(PlayerBucketFillEvent event) {
        this.onBucket((PlayerBucketEvent)event, Messages.PLAYER_FILL_BUCKET_NEXT);
    }

    @EventHandler
    public void onDispense(@NotNull BlockDispenseEvent event) {
        BlockData blockData;
        Block sourceBlock = event.getBlock();
        if (!this.plugin.getWorldManager().isWorldWithBase(sourceBlock.getWorld())) {
            return;
        }
        if (!this.plugin.getFkPI().getRulesManager().getRule(Rule.BLAST_PROOF_BASE).booleanValue() && Version.VersionType.V1_13.isHigherOrEqual() && event.getItem().getType() == Material.WATER_BUCKET && (blockData = sourceBlock.getBlockData()) instanceof Directional) {
            Block targetBlock = sourceBlock.getRelative(((Directional)blockData).getFacing());
            if (this.plugin.getFkPI().getTeamManager().getBase(targetBlock).isPresent() && targetBlock.getBlockData() instanceof Waterlogged) {
                event.setCancelled(true);
            }
        }
    }

    private void onBucket(@NotNull PlayerBucketEvent event, Messages message) {
        Player player = event.getPlayer();
        Block block = event.getBlockClicked();
        if (player.getGameMode() == GameMode.CREATIVE || !this.plugin.getWorldManager().isWorldWithBase(player.getWorld())) {
            return;
        }
        Team playerTeam = this.plugin.getFkPI().getTeamManager().getPlayerTeam(player);
        if (playerTeam == null || this.plugin.getGame().isPreStart()) {
            return;
        }
        if (!this.plugin.getFkPI().getRulesManager().getRule(Rule.BUCKET_ASSAULT).booleanValue()) {
            for (Team team : Fk.getInstance().getFkPI().getTeamManager().getTeams()) {
                if (playerTeam.equals(team) || team.getBase() == null || !team.getBase().contains(block, 3)) continue;
                ChatUtils.sendMessage((CommandSender)player, message);
                event.setCancelled(true);
                return;
            }
        }
        if (!this.plugin.getFkPI().getRulesManager().getRule(Rule.BLAST_PROOF_BASE).booleanValue() && Version.VersionType.V1_13.isHigherOrEqual()) {
            BlockData blockData = block.getBlockData();
            if (this.plugin.getFkPI().getTeamManager().getBase(block).isPresent() && blockData instanceof Waterlogged) {
                ChatUtils.sendMessage((CommandSender)player, message);
                event.setCancelled(true);
            }
        }
    }
}

