/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.listeners.entity;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.Environment;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.rules.ChargedCreepers;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.CrystalCore;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageListener
implements Listener {
    @EventHandler
    public void damage(EntityDamageEvent e) {
        if (!Fk.getInstance().getWorldManager().isAffected(e.getEntity().getWorld())) {
            return;
        }
        if (Fk.getInstance().getGame().isPaused() && e.getCause() != EntityDamageEvent.DamageCause.VOID) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (this.isCristal(event.getDamager()) || event.getDamager().hasMetadata("nodamage")) {
            event.setCancelled(true);
            return;
        }
        if (!(entity instanceof EnderCrystal)) {
            return;
        }
        if (!Fk.getInstance().getWorldManager().isAffected(entity.getWorld())) {
            return;
        }
        Player damager = DamageListener.getOwner(event.getDamager());
        Team playerTeam = damager == null ? null : FkPI.getInstance().getTeamManager().getPlayerTeam(damager);
        for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
            Nexus nexus;
            Base base = team.getBase();
            if (base == null || !((nexus = base.getNexus()) instanceof CrystalCore)) continue;
            CrystalCore core = (CrystalCore)nexus;
            if (!entity.getUniqueId().equals(core.getEntityId())) continue;
            event.setCancelled(true);
            if (damager == null) {
                return;
            }
            if (!Fk.getInstance().getGame().isAssaultsEnabled() || !FkPI.getInstance().getChestsRoomsManager().isEnabled()) {
                ChatUtils.sendMessage((CommandSender)damager, Messages.PLAYER_TNT_NOT_ACTIVE);
                return;
            }
            if (Fk.getInstance().getGame().isPaused()) {
                ChatUtils.sendMessage((CommandSender)damager, Messages.PLAYER_PAUSE);
                return;
            }
            if (playerTeam == null) {
                ChatUtils.sendMessage((CommandSender)damager, Messages.PLAYER_CHEST_ATTACK_TEAM.getMessage().replace("%team%", team.getName()));
                return;
            }
            if (playerTeam == team) {
                ChatUtils.sendMessage((CommandSender)damager, Messages.PLAYER_CHEST_ATTACK_SELF);
                return;
            }
            if (!core.isInside(damager)) {
                core.addEnemyInside(damager);
            }
            if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
                entity.getWorld().spawnParticle(Particle.CRIT, entity.getLocation(), 10, 0.5, 0.5, 0.5, 0.1);
            }
            core.damage(playerTeam, (int)event.getFinalDamage());
            return;
        }
    }

    @Nullable
    private static Player getOwner(@NotNull Entity entity) {
        ProjectileSource shooter;
        if (entity instanceof Player) {
            return (Player)entity;
        }
        if (entity instanceof Projectile && (shooter = ((Projectile)entity).getShooter()) instanceof Player) {
            return (Player)shooter;
        }
        return null;
    }

    private boolean isCristal(@NotNull Entity entity) {
        if (!(entity instanceof EnderCrystal)) {
            return false;
        }
        for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
            Nexus nexus;
            Base base = team.getBase();
            if (base == null || !((nexus = base.getNexus()) instanceof CrystalCore)) continue;
            CrystalCore core = (CrystalCore)nexus;
            if (!entity.getUniqueId().equals(core.getEntityId())) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void creeperDeath(EntityDeathEvent e) {
        if (!Fk.getInstance().getWorldManager().isAffected(e.getEntity().getWorld())) {
            return;
        }
        ChargedCreepers rule = FkPI.getInstance().getRulesManager().getRule(Rule.CHARGED_CREEPERS);
        if (e.getEntity() instanceof Creeper && ((Creeper)e.getEntity()).isPowered() && new Random().nextInt(100) <= rule.getDrop()) {
            e.getDrops().add(new ItemStack(Material.TNT, rule.getTntAmount()));
        }
    }

    @EventHandler
    public void dead(PlayerDeathEvent e) {
        FkPlayer fkP;
        if (e.getEntity().hasMetadata("NPC") || !Fk.getInstance().getWorldManager().isAffected(e.getEntity().getWorld())) {
            return;
        }
        Environment.setDeathMessage(e, FkPI.getInstance().getTeamManager().getPlayerTeam(e.getEntity()), FkPI.getInstance().getTeamManager().getPlayerTeam(e.getEntity().getKiller()));
        if (e.getEntity().getKiller() != null && FkPI.getInstance().getTeamManager().getPlayerTeam(e.getEntity().getKiller()) != null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!Fk.getInstance().getWorldManager().isAffected(p.getWorld())) continue;
                Fk.getInstance().getDisplayService().playDeathSound(p);
            }
            if (e.getEntity().getKiller() != null && !e.getEntity().getKiller().getName().equals(e.getEntity().getName())) {
                Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity().getKiller()).addKill();
            }
        }
        if (Fk.getInstance().getGame().isPreStart() || Fk.getInstance().getFkPI().getTeamManager().getPlayerTeam(e.getEntity()) == null || e.getEntity().getKiller() != null && Fk.getInstance().getFkPI().getTeamManager().getPlayerTeam(e.getEntity().getKiller()) == null) {
            return;
        }
        Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity()).addDeath();
        if (FkPI.getInstance().getRulesManager().getRule(Rule.DEATH_LIMIT) > 0) {
            if (Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity()).getDeaths() >= FkPI.getInstance().getRulesManager().getRule(Rule.DEATH_LIMIT)) {
                Fk.broadcast(Messages.BROADCAST_PLAYER_ELIMINATED.getMessage().replace("%player%", e.getEntity().getDisplayName()));
                e.getEntity().setGameMode(GameMode.SPECTATOR);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!Fk.getInstance().getWorldManager().isAffected(p.getWorld())) continue;
                    Fk.getInstance().getDisplayService().playEliminationSound(p);
                }
            } else {
                ChatUtils.sendMessage((CommandSender)e.getEntity(), Messages.PLAYER_LIFES_REMAINING.getMessage().replace("%amount%", String.valueOf(Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity()).getDeaths())).replace("%over%", String.valueOf(FkPI.getInstance().getRulesManager().getRule(Rule.DEATH_LIMIT)).replace("%unit%", Messages.Unit.TRY.tl(Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity()).getDeaths()))));
            }
        }
        if ((fkP = Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)e.getEntity())).getState() == FkPlayer.PlayerState.EDITING_SCOREBOARD) {
            fkP.getSbDisplayer().exit();
        }
        Fk.getInstance().getDisplayService().updateAll(PlaceHolder.KILLS_RELATIVE);
    }
}

