/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager;

import com.google.common.collect.ImmutableList;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.AbstractCommand;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.chests.FkChestsCommand;
import fr.devsylone.fallenkingdom.commands.debug.Bug;
import fr.devsylone.fallenkingdom.commands.debug.Debug;
import fr.devsylone.fallenkingdom.commands.game.FkGameCommand;
import fr.devsylone.fallenkingdom.commands.lang.FkLangCommand;
import fr.devsylone.fallenkingdom.commands.rules.FkRuleCommand;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.RulesList;
import fr.devsylone.fallenkingdom.commands.scoreboard.FkScoreboardCommand;
import fr.devsylone.fallenkingdom.commands.teams.FkTeamCommand;
import fr.devsylone.fallenkingdom.exception.ArgumentParseException;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.game.Game;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandManager {
    private final List<? extends AbstractCommand> mainCommands = ImmutableList.builder().add((Object)new Bug()).add((Object)new FkChestsCommand()).add((Object)new Debug()).add((Object)new FkGameCommand()).add((Object)new FkLangCommand()).add((Object)new FkRuleCommand()).add((Object)new FkScoreboardCommand()).add((Object)new FkTeamCommand()).build();
    private final boolean permissions;

    public CommandManager(boolean permissions) {
        this.permissions = permissions;
    }

    public CommandResult executeCommand(Fk plugin, CommandSender sender, String label, List<String> arguments) {
        CommandResult result;
        if (!arguments.isEmpty() && arguments.get(0).equalsIgnoreCase("help")) {
            this.sendMainHelp(sender, label);
            return CommandResult.SUCCESS;
        }
        String token = !arguments.isEmpty() ? arguments.get(0) : "";
        AbstractCommand main = this.mainCommands.stream().filter(cmd -> cmd.getName().equals(token)).findFirst().orElse(null);
        if (main == null) {
            this.sendCommandUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        arguments.remove(0);
        main = main.get(arguments);
        if (this.permissions && !main.hasPermission(sender)) {
            return CommandResult.NO_PERMISSION;
        }
        if (!main.isValidExecutor(sender)) {
            return CommandResult.NOT_VALID_EXECUTOR;
        }
        if (main.getMinArgumentCount() > arguments.size()) {
            sender.sendMessage(ChatColor.RED.toString() + (Object)((Object)Messages.CMD_ERROR_UNKNOWN_ARG) + label + " " + main.getFullUsage());
            return CommandResult.INVALID_ARGS;
        }
        try {
            result = main.execute(plugin, sender, arguments, label);
        }
        catch (ArgumentParseException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            result = CommandResult.INVALID_ARGS;
        }
        catch (FkLightException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            if (sender instanceof Player) {
                plugin.getLogger().info(Messages.CONSOLE_LIGHT_ERROR.getMessage() + " " + e.getMessage());
            }
            result = CommandResult.STATE_ERROR;
        }
        catch (Throwable e) {
            e.printStackTrace();
            sender.sendMessage("\u00a7c" + (Object)((Object)Messages.CMD_ERROR));
            result = CommandResult.FAILURE;
        }
        if (main.getClass().getName().contains("rulescommands") && !(main instanceof RulesList) && plugin.getGame().getState().equals((Object)Game.GameState.BEFORE_STARTING)) {
            plugin.getDisplayService().updateAll(new PlaceHolder[0]);
        }
        plugin.getTipsManager().addUsed(main);
        return result;
    }

    public CommandResult executeCommand(Fk plugin, CommandSender sender, String literal) {
        return this.executeCommand(plugin, sender, "fk", new ArrayList<String>(Arrays.asList(literal.split(" "))));
    }

    public List<String> tabCompleteCommand(Fk plugin, CommandSender sender, List<String> arguments) {
        if (arguments.size() == 1) {
            return this.mainCommands.stream().filter(AbstractCommand::shouldDisplay).filter(c -> c.getName().startsWith((String)arguments.get(0))).filter(c -> !this.permissions || c.hasPermission(sender)).map(AbstractCommand::getName).collect(Collectors.toList());
        }
        Optional<AbstractCommand> main = this.mainCommands.stream().filter(AbstractCommand::shouldDisplay).filter(cmd -> cmd.getName().equals(arguments.get(0))).findFirst();
        if (main.isPresent()) {
            arguments.remove(0);
            return main.get().get(arguments).tabComplete(plugin, sender, arguments);
        }
        return Collections.emptyList();
    }

    public Optional<? extends AbstractCommand> search(Class<? extends AbstractCommand> command) {
        for (AbstractCommand abstractCommand : this.mainCommands) {
            AbstractCommand c = abstractCommand.get(command);
            if (c == null) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    private void sendCommandUsage(CommandSender sender, String label) {
        sender.sendMessage(ChatColor.RED + Messages.CMD_ERROR_UNKNOWN.getMessage().replace("%help%", "/" + label + " help"));
    }

    private void sendMainHelp(CommandSender sender, String label) {
        this.mainCommands.stream().filter(c -> !this.permissions || c.hasPermission(sender)).filter(AbstractCommand::shouldDisplay).forEach(c -> sender.sendMessage(ChatColor.GREEN + "/" + label + " " + c.getFullUsage() + " " + ChatColor.GRAY + c.getDescription()));
    }

    public List<? extends AbstractCommand> getMainCommands() {
        return this.mainCommands;
    }

    public boolean hasPermission(CommandSender sender, String permission) {
        return !this.permissions || sender.hasPermission(permission);
    }

    public boolean withPermissions() {
        return this.permissions;
    }
}

