/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.Unmodifiable;

public class LanguageManager {
    public static final String MESSAGES_BUNDLE = "messages";
    public static final String LOCALES = "locales";
    private static final String[] BUNDLED_LOCALES = new String[]{"fr", "en"};
    private static final ResourceBundle NULL_BUNDLE = new ResourceBundle(){

        @Override
        @NotNull
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(@NotNull String key) {
            return null;
        }
    };
    private final ResourceBundle defaultBundle;
    private final Set<String> untranslatedKeys = new HashSet<String>(0);
    private final Fk plugin;
    private ResourceBundle localeBundle;
    private ResourceBundle customBundle;
    private Locale locale;

    public LanguageManager(@NotNull Fk plugin) {
        this.defaultBundle = ResourceBundle.getBundle(MESSAGES_BUNDLE, Locale.FRENCH, new UTF8PropertiesControl());
        this.plugin = plugin;
        this.copyDefaultTranslations();
        this.updateLocale(LanguageManager.parseLocale(plugin.getConfig().getString("lang", "unknown")));
        if (!this.isLocaleSet()) {
            plugin.addOnConnectWarning(this.createInvite());
        }
    }

    public void updateLocale(@NotNull Locale userLocale) {
        ResourceBundle.clearCache();
        try {
            this.localeBundle = ResourceBundle.getBundle(MESSAGES_BUNDLE, userLocale, new UTF8PropertiesControl());
        }
        catch (MissingResourceException ex) {
            this.localeBundle = NULL_BUNDLE;
        }
        try {
            this.customBundle = ResourceBundle.getBundle(MESSAGES_BUNDLE, userLocale, new FileResClassLoader(((Object)((Object)this.plugin)).getClass().getClassLoader(), this.plugin), new UTF8PropertiesControl());
        }
        catch (MissingResourceException ex) {
            this.customBundle = NULL_BUNDLE;
        }
        this.locale = userLocale;
    }

    @NotNull
    public String get(@NotNull Messages key) {
        return this.translate(key.getAccessor());
    }

    @NotNull
    private String translate(@PropertyKey(resourceBundle="messages") @NotNull @PropertyKey(resourceBundle="messages") @NotNull String string) {
        try {
            return this.customBundle.getString(string);
        }
        catch (MissingResourceException ex) {
            try {
                return this.localeBundle.getString(string);
            }
            catch (MissingResourceException ex2) {
                if (this.untranslatedKeys.add(string) && this.isLocaleSet()) {
                    this.plugin.getLogger().log(Level.WARNING, String.format("Missing translation key \"%s\" in translation file \"%s\"", ex2.getKey(), this.locale.toString()));
                }
                return this.defaultBundle.getString(string);
            }
        }
    }

    private void copyDefaultTranslations() {
        Path localeDir = this.plugin.getDataFolder().toPath().resolve(LOCALES);
        try {
            Files.createDirectories(localeDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create locales folder", ex);
            return;
        }
        for (String locale : BUNDLED_LOCALES) {
            String fileName = String.format("%s_%s.properties", MESSAGES_BUNDLE, locale);
            try (InputStream stream2 = Fk.class.getResourceAsStream("/" + fileName);){
                Objects.requireNonNull(stream2, "failed to read bundled translation file");
                Files.copy(stream2, localeDir.resolve(fileName), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException stream2) {
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to copy " + locale + " translation file to plugin folder", ex);
            }
        }
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    public boolean isLocaleSet() {
        return this.localeBundle.getLocale() != null;
    }

    @NotNull
    public BaseComponent[] createInvite() {
        TextComponent builder = new TextComponent("Veuillez s\u00e9lectionner votre langue en cliquant dessus.\n\u21aa Please select your language by clicking on it.\n\u21aa Bitte w\u00e4hlen Sie Ihre Sprache aus, indem Sie darauf klicken.\n");
        builder.setColor(ChatColor.RED);
        TextComponent leftBracket = new TextComponent("[");
        leftBracket.setColor(ChatColor.GRAY);
        TextComponent rightBracket = new TextComponent("]");
        rightBracket.setColor(ChatColor.GRAY);
        TextComponent space = null;
        for (String locale : this.listLocales()) {
            TextComponent component = new TextComponent(locale);
            component.setColor(ChatColor.DARK_AQUA);
            component.setUnderlined(Boolean.valueOf(true));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.BLUE + "Use this locale").create()));
            component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/fk lang set " + locale));
            builder.addExtra((BaseComponent)leftBracket);
            builder.addExtra((BaseComponent)component);
            builder.addExtra((BaseComponent)rightBracket);
            if (space != null) {
                builder.addExtra(space);
                continue;
            }
            space = new TextComponent(" ");
        }
        BaseComponent[] prefix = TextComponent.fromLegacyText((String)"\u00a77[\u00a75Fk\u00a77] ");
        BaseComponent[] result = new BaseComponent[prefix.length + 1];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        result[prefix.length] = builder;
        return result;
    }

    @NotNull
    public @Unmodifiable List<String> listLocales() {
        List<String> list;
        block8: {
            Stream<Path> files = Files.list(this.plugin.getDataFolder().toPath().resolve(LOCALES));
            try {
                list = files.filter(path -> {
                    if (!Files.isRegularFile(path, new LinkOption[0])) {
                        return false;
                    }
                    String name = path.getFileName().toString();
                    return name.startsWith("messages_") && name.endsWith(".properties");
                }).map(path -> {
                    String name = path.getFileName().toString();
                    return name.substring(MESSAGES_BUNDLE.length() + 1, name.lastIndexOf(46));
                }).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return Arrays.asList(BUNDLED_LOCALES);
                }
            }
            files.close();
        }
        return list;
    }

    public boolean isLocaleAvailable(@NotNull String locale) {
        return Files.exists(this.plugin.getDataFolder().toPath().resolve(LOCALES).resolve(String.format("%s_%s.properties", MESSAGES_BUNDLE, locale)), new LinkOption[0]) || Arrays.asList(BUNDLED_LOCALES).contains(locale);
    }

    @NotNull
    public static Locale parseLocale(@Nullable String languageTag) {
        String[] parts;
        String[] stringArray = parts = languageTag == null ? new String[]{} : languageTag.split("[_\\.]");
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return parts.length > 0 ? new Locale(parts[0]) : Locale.getDefault();
    }

    private static class UTF8PropertiesControl
    extends ResourceBundle.Control {
        private UTF8PropertiesControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    bundle = new PropertyResourceBundle(reader);
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }

        @Override
        @Nullable
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return null;
        }
    }

    private static class FileResClassLoader
    extends ClassLoader {
        private final File dataFolder;

        FileResClassLoader(@NotNull ClassLoader classLoader, @NotNull Fk plugin) {
            super(classLoader);
            this.dataFolder = new File(plugin.getDataFolder(), LanguageManager.LOCALES);
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.dataFolder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.dataFolder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

