/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.updater.FilesUpdater;
import fr.devsylone.fallenkingdom.utils.FkConfig;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.ZipUtils;
import fr.devsylone.fkpi.util.Saveable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipOutputStream;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class SaveablesManager {
    private final Fk plugin;
    private final Map<String, FkConfig> files = new HashMap<String, FkConfig>();
    private final Map<Saveable, FkConfig> saveables = new LinkedHashMap<Saveable, FkConfig>();
    private FilesUpdater filesUpdater;
    private long lastSave = 0L;

    public SaveablesManager(@NotNull Fk fk) {
        this.plugin = fk;
        FkConfig mainConfig = this.getFileConfiguration("save.yml");
        this.registerSaveable(fk.getFkPI(), "save.yml");
        this.registerSaveable(fk.getGame(), "save.yml");
        this.registerSaveable(fk.getPlayerManager(), "save.yml");
        this.registerSaveable(fk.getStarterInventoryManager(), "save.yml");
        this.registerSaveable(fk.getPauseRestorer(), "pause_restorer.yml");
        this.registerSaveable(fk.getDisplayService(), "display.yml");
        this.registerSaveable(fk.getDeepPauseManager(), "deep_pause.yml");
        this.registerSaveable(fk.getPortalsManager(), "portals.yml");
        mainConfig.load();
        this.filesUpdater = new FilesUpdater(mainConfig.getString("last_version", fk.getDescription().getVersion()));
        mainConfig.set("last_version", fk.getDescription().getVersion());
        mainConfig.saveSync();
    }

    public void update() {
        this.filesUpdater.update();
        this.filesUpdater = null;
    }

    public void delayedSaveAll() {
        this.updateMemoryConfig();
        for (FkConfig config : this.files.values()) {
            config.delayedSave();
        }
    }

    public void loadAll() {
        for (FkConfig fkConfig : this.files.values()) {
            fkConfig.load();
        }
        LinkedList<FkConfig> corrupted = new LinkedList<FkConfig>();
        for (Map.Entry<Saveable, FkConfig> entry : this.saveables.entrySet()) {
            Saveable saveable = entry.getKey();
            FkConfig configFile = entry.getValue();
            try {
                saveable.loadNullable(configFile.contains(saveable.getClass().getSimpleName()) ? configFile.getConfigurationSection(saveable.getClass().getSimpleName()) : configFile.createSection(saveable.getClass().getSimpleName()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                corrupted.add(configFile);
            }
        }
        if (!corrupted.isEmpty()) {
            this.plugin.addOnConnectWarning(Messages.CORRUPT_CONFIG_FILES.getMessage());
            File file = new File(this.plugin.getDataFolder(), "invalid-" + new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(Calendar.getInstance().getTimeInMillis()) + ".zip");
            try {
                file.createNewFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                     ZipOutputStream zipStream = new ZipOutputStream(fileOutputStream);){
                    ZipUtils.zipConfig(this.plugin.getDataFolder().toPath(), zipStream);
                    zipStream.flush();
                }
                for (FkConfig file2 : corrupted) {
                    file2.delete();
                }
            }
            catch (IOException iOException) {
                this.plugin.getLogger().log(Level.SEVERE, Messages.CONSOLE_UNABLE_TO_MAKE_BACKUP.getMessage(), iOException);
            }
        }
        this.plugin.getDisplayService().updateAll(new PlaceHolder[0]);
    }

    private void registerSaveable(Saveable o, String file) {
        this.saveables.put(o, this.getFileConfiguration(file));
    }

    public void reset() {
        for (FileConfiguration fileConfiguration : this.saveables.values()) {
            for (String key : fileConfiguration.getKeys(false)) {
                fileConfiguration.set(key, null);
            }
        }
    }

    @NotNull
    public FkConfig getFileConfiguration(@NotNull String path) {
        return this.files.computeIfAbsent(path, this::loadFile);
    }

    @NotNull
    public FkConfig getTempFileConfiguration(@NotNull String path) {
        FkConfig config = this.files.get(path);
        if (config == null) {
            return this.loadFile(path);
        }
        return config;
    }

    @NotNull
    private FkConfig loadFile(@NotNull String filename) {
        return new FkConfig(new File(this.plugin.getDataFolder(), filename));
    }

    private void updateMemoryConfig() {
        this.lastSave = System.currentTimeMillis();
        for (Map.Entry<Saveable, FkConfig> entry : this.saveables.entrySet()) {
            Saveable saveable = entry.getKey();
            ConfigurationSection section = entry.getValue().createSection(saveable.getClass().getSimpleName());
            saveable.save(section);
        }
    }

    public long getLastSave() {
        return this.lastSave;
    }
}

