/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.AbstractCommand;
import fr.devsylone.fallenkingdom.commands.chests.chestscommands.Add;
import fr.devsylone.fallenkingdom.commands.chests.chestscommands.ChestLock;
import fr.devsylone.fallenkingdom.commands.debug.Bug;
import fr.devsylone.fallenkingdom.commands.game.gamescommands.Restore;
import fr.devsylone.fallenkingdom.commands.game.gamescommands.StarterInv;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.AutoPause;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.ChargedCreepers;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.DayDuration;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.DisabledPotions;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.PlaceBlockInCave;
import fr.devsylone.fallenkingdom.commands.rules.rulescommands.booleancommands.TntJump;
import fr.devsylone.fallenkingdom.commands.scoreboard.scoreboardcommands.Edit;
import fr.devsylone.fallenkingdom.players.Tip;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TipsManager {
    private final List<Tip> tips = new ArrayList<Tip>();
    private final Set<Tip> displayed = new HashSet<Tip>();
    private final Set<Tip> used = new HashSet<Tip>();
    private final int tipsSize;
    private int task;

    public TipsManager() {
        this.newTip(AutoPause.class, Messages.TIP_AUTO_PAUSE);
        this.newTip(TntJump.class, Messages.TIP_TNT_JUMP);
        this.newTip(ChargedCreepers.class, Messages.TIP_CHARGED_CREEPERS);
        this.newTip(Edit.class, Messages.TIP_SCOREBOARD_EDIT);
        this.newTip(Bug.class, Messages.TIP_BUG);
        this.newTip(Restore.class, Messages.TIP_RESTORE);
        this.newTip(StarterInv.class, Messages.TIP_STARTER_INV);
        this.newTip(PlaceBlockInCave.class, Messages.TIP_PLACE_BLOCK_IN_CAVE);
        this.newTip(Add.class, Messages.TIP_LOCKED_CHEST);
        this.newTip(DayDuration.class, Messages.TIP_DAY_DURATION);
        this.newTip(DisabledPotions.class, Messages.TIP_DISABLED_POTIONS);
        this.newTip(ChestLock.class, Messages.TIP_CHEST_LOCK);
        this.newTip(null, Messages.TIP_TAB_COMPLETION);
        this.newTip(null, Messages.TIP_DISCORD);
        this.newTip(null, Messages.TIP_WATER_NEXT_TO_BASE);
        this.newTip(null, Messages.TIP_FK_ADVERTISEMENTS);
        this.tipsSize = this.tips.size();
    }

    private void newTip(Class<? extends AbstractCommand> cmd, Messages tip) {
        this.tips.add(new Tip(cmd, tip));
    }

    public void sendRandomTip() {
        Random rdm = new Random();
        Tip tip = null;
        while (tip == null || this.displayed.contains(tip) || this.used.contains(tip)) {
            tip = this.tips.get(rdm.nextInt(this.tipsSize));
        }
        this.displayed.add(tip);
        if (!tip.getTip().isEmpty()) {
            Fk.broadcast(" ");
            Fk.broadcast(tip.getChatFormatted(), Messages.PREFIX_TIP.getMessage(), FkSound.NOTE_PLING);
            Fk.broadcast(" ");
        }
        if (this.displayed.size() + this.used.size() >= this.tips.size()) {
            this.displayed.clear();
        }
    }

    public void startBroadcasts() {
        this.task = new BukkitRunnable(){

            public void run() {
                if (Fk.getInstance().getGame().isPreStart()) {
                    TipsManager.this.sendRandomTip();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Fk.getInstance(), 3600L, 3600L).getTaskId();
    }

    public void addUsed(AbstractCommand cmd) {
        Optional<Tip> usedTip = this.tips.stream().filter(t -> t.getCommandClass() != null && t.getCommandClass().equals(cmd.getClass())).findFirst();
        if (usedTip.isPresent()) {
            this.used.add(usedTip.get());
        }
    }

    public void cancelBroadcasts() {
        Bukkit.getScheduler().cancelTask(this.task);
    }
}

