/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager;

import com.google.common.collect.ImmutableSet;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.managers.TeamManager;
import fr.devsylone.fkpi.teams.Team;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldManager {
    private final boolean perWorld;
    private final Set<UUID> affectedWorlds;
    private final Set<UUID> baseWorldsCache = new HashSet<UUID>();

    public WorldManager(Fk plugin) {
        this.perWorld = plugin.getConfig().getBoolean("world-check", false);
        if (!this.perWorld) {
            this.affectedWorlds = Collections.emptySet();
            return;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        plugin.getConfig().getStringList("affected-worlds").forEach(current -> {
            World world = Bukkit.getWorld((String)current);
            if (world == null) {
                plugin.getLogger().warning(Messages.CONSOLE_WORLD_NOT_FOUND_1.getMessage() + " " + current + " " + Messages.CONSOLE_WORLD_NOT_FOUND_2.getMessage());
            } else {
                builder.add((Object)world.getUID());
            }
        });
        this.affectedWorlds = builder.build();
    }

    public Set<UUID> getAffectedWorlds() {
        return this.affectedWorlds;
    }

    public boolean isAffected(World world) {
        if (!this.perWorld) {
            return true;
        }
        return this.affectedWorlds.contains(world.getUID());
    }

    public boolean isWorldWithBase(World world) {
        return this.isAffected(world) && this.baseWorldsCache.contains(world.getUID());
    }

    public void invalidateBaseWorldsCache(TeamManager teamManager) {
        this.baseWorldsCache.clear();
        for (Team team : teamManager.getTeams()) {
            if (team.getBase() == null || team.getBase().getCenter().getWorld() == null) continue;
            this.baseWorldsCache.add(team.getBase().getCenter().getWorld().getUID());
        }
    }
}

