/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager.saveable;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager
implements Saveable {
    protected final GlobalDisplayService displayService;
    protected final Map<UUID, Location> onTnt = new HashMap<UUID, Location>();
    protected final Map<UUID, FkPlayer> playersByUUID = new HashMap<UUID, FkPlayer>();
    protected final Map<String, FkPlayer> playersByString = new HashMap<String, FkPlayer>();

    public PlayerManager(@NotNull GlobalDisplayService displayService) {
        this.displayService = displayService;
    }

    @NotNull
    public @NotNull Collection<@NotNull FkPlayer> players() {
        return this.playersByString.values();
    }

    @NotNull
    public @NotNull List<@NotNull FkPlayer> getConnectedPlayers() {
        LinkedList<FkPlayer> players = new LinkedList<FkPlayer>();
        for (Map.Entry<UUID, FkPlayer> entry : this.playersByUUID.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            players.add(entry.getValue());
        }
        return players;
    }

    @NotNull
    public @NotNull List<@NotNull Player> getOnlinePlayers() {
        LinkedList<Player> players = new LinkedList<Player>();
        for (Map.Entry<UUID, FkPlayer> entry : this.playersByUUID.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            players.add(player);
        }
        return players;
    }

    public void putOnTnt(@NotNull UUID player, @NotNull Location tnt) {
        this.onTnt.put(player, tnt);
    }

    public boolean wasOnTnt(@NotNull UUID player) {
        return this.onTnt.containsKey(player);
    }

    public void removeOnTnt(@NotNull UUID player) {
        this.onTnt.remove(player);
    }

    @Nullable
    public Location getTntLoc(@NotNull UUID player) {
        return this.onTnt.get(player);
    }

    @NotNull
    public FkPlayer getPlayer(@NotNull String name) {
        FkPlayer fkPlayer = this.playersByString.get(name);
        if (fkPlayer != null) {
            return fkPlayer;
        }
        fkPlayer = new FkPlayer(name, this.displayService);
        this.playersByString.put(name, fkPlayer);
        return fkPlayer;
    }

    @NotNull
    public FkPlayer getPlayer(@NotNull OfflinePlayer player) {
        FkPlayer fkPlayer = this.playersByUUID.get(player.getUniqueId());
        if (fkPlayer != null) {
            return fkPlayer;
        }
        fkPlayer = this.getPlayer(Objects.requireNonNull(player.getName(), "player name is not set"));
        this.playersByUUID.put(player.getUniqueId(), fkPlayer);
        return fkPlayer;
    }

    @Nullable
    public FkPlayer getPlayerIfExist(@NotNull Player player) {
        return this.playersByUUID.get(player.getUniqueId());
    }

    @Override
    public void load(ConfigurationSection config) {
        ConfigurationSection section = config.getConfigurationSection("Players");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            this.getPlayer(key).loadNullable(section.getConfigurationSection(key));
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        for (Map.Entry<String, FkPlayer> entry : this.playersByString.entrySet()) {
            entry.getValue().save(config.createSection("Players." + entry.getKey()));
        }
    }
}

