/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager.saveable;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fkpi.util.Saveable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class PortalsManager
implements Saveable {
    private final Set<Location> portals = new HashSet<Location>();

    public void addPortal(Location loc) {
        this.portals.add(loc);
    }

    public void enablePortals() {
        Material caveAir = XMaterial.CAVE_AIR.parseMaterial();
        for (Location loc : this.portals) {
            if (loc == null || loc.getBlock() == null || !loc.getBlock().getType().equals((Object)Material.AIR) && !loc.getBlock().getType().equals((Object)caveAir)) continue;
            loc.getBlock().setType(Material.FIRE);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Fk.getInstance(), () -> {
                if (loc.getBlock().getType().equals((Object)Material.FIRE)) {
                    loc.getBlock().setType(Material.AIR);
                }
            }, 20L);
        }
    }

    @Override
    public void load(ConfigurationSection config) {
        for (String serialized : config.getStringList("Portals")) {
            Location location = ConfigHelper.getLocation(serialized);
            if (location == null) continue;
            this.addPortal(location);
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("Portals", this.portals.stream().map(ConfigHelper::serializeBlockPos).collect(Collectors.toList()));
    }
}

