/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.manager.saveable;

import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.PluginInventory;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class StarterInventoryManager
implements Saveable {
    private ItemStack[] armors = new ItemStack[4];
    private ItemStack[] inventory = new ItemStack[0];
    private ItemStack[] lastArmors = this.armors;
    private ItemStack[] lastInventory = this.inventory;

    public void setStarterInv(PlayerInventory inv) {
        this.lastArmors = this.armors;
        this.lastInventory = this.inventory;
        this.armors = (ItemStack[])Arrays.stream(inv.getArmorContents()).map(item -> item == null ? null : item.clone()).toArray(ItemStack[]::new);
        this.inventory = (ItemStack[])Arrays.stream(inv.getContents()).map(item -> item == null ? null : item.clone()).toArray(ItemStack[]::new);
    }

    public boolean undo() {
        if (this.inventory == this.lastInventory) {
            return false;
        }
        this.armors = this.lastArmors;
        this.inventory = this.lastInventory;
        return true;
    }

    public void applyStarterInv(Player p) {
        p.getInventory().clear();
        p.getInventory().setArmorContents(this.armors);
        p.getInventory().setContents(this.inventory);
        p.updateInventory();
    }

    @NotNull
    public PluginInventory show(Player p) {
        int i;
        StarterInventory pluginInv = new StarterInventory();
        Inventory inv = Bukkit.createInventory((InventoryHolder)pluginInv, (int)54, (String)Messages.CMD_MAP_GAME_STARTER_INV_INVENTORY.getMessage());
        pluginInv.inventory = inv;
        for (i = 0; i < this.armors.length; ++i) {
            inv.setItem(i, this.armors[i]);
        }
        for (i = 0; i < this.inventory.length; ++i) {
            if (i < 9) {
                inv.setItem(45 + i, this.inventory[i]);
                continue;
            }
            if (i >= 36) {
                inv.setItem(i - 36, this.inventory[i]);
                continue;
            }
            inv.setItem(9 + i, this.inventory[i]);
        }
        p.openInventory(inv);
        return pluginInv;
    }

    @Override
    public void load(ConfigurationSection config) {
        if (config.contains("armors")) {
            for (String key : config.getConfigurationSection("armors").getKeys(false)) {
                this.armors[Integer.parseInt((String)key)] = config.getItemStack("armors." + key);
            }
        }
        if (config.contains("inventory")) {
            Integer[] keys = (Integer[])config.getConfigurationSection("inventory").getKeys(false).stream().map(Integer::parseInt).toArray(Integer[]::new);
            this.inventory = new ItemStack[keys[keys.length - 1] + 1];
            Integer[] integerArray = keys;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int key = integerArray[i];
                this.inventory[key] = config.getItemStack("inventory." + key);
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        int i;
        for (i = 0; i < this.armors.length; ++i) {
            if (this.armors[i] == null) continue;
            config.set("armors." + i, (Object)this.armors[i]);
        }
        for (i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            config.set("inventory." + i, (Object)this.inventory[i]);
        }
    }

    private static class StarterInventory
    implements PluginInventory {
        private Inventory inventory;

        private StarterInventory() {
        }

        @Override
        public void onInventoryClick(@NotNull InventoryClickEvent event) {
            event.setCancelled(true);
        }

        @NotNull
        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

