/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.pause;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.pause.PausedPlayer;
import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PauseRestorer
implements Saveable {
    private int lastID = 0;
    private final Map<Integer, List<PausedPlayer>> pauses = new HashMap<Integer, List<PausedPlayer>>();

    public void registerPlayer(int id, Player p) {
        this.registerPlayer(id, new PausedPlayer(p));
    }

    public void registerPlayer(int id, PausedPlayer pp) {
        List pausedPlayers = this.pauses.computeIfAbsent(id, s -> new ArrayList());
        pausedPlayers.remove(pp);
        pausedPlayers.add(pp);
    }

    public int registerAll() {
        int id = ++this.lastID;
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.registerPlayer(id, p);
        }
        return id;
    }

    public int restoreAll(int id) {
        List<PausedPlayer> pausedPlayers;
        if (id < 0) {
            id = this.lastID;
        }
        if ((pausedPlayers = this.pauses.get(id)) == null) {
            throw new FkLightException(Messages.CMD_GAME_RESTORE_INVALID_ID);
        }
        LinkedList<String> failed = new LinkedList<String>();
        for (PausedPlayer p : pausedPlayers) {
            if (p.tryRestore()) continue;
            failed.add(p.getPlayer());
        }
        if (!failed.isEmpty()) {
            Fk.broadcast((Object)((Object)Messages.CMD_GAME_RESTORE_DISCONNECTED_PLAYERS) + " \u00a7b" + String.join((CharSequence)"\u00a7c, \u00a7b", failed));
        }
        return id;
    }

    @Override
    public void load(ConfigurationSection config) {
        ConfigHelper.loadSectionsWithIndex(config, (id, section) -> this.registerPlayer((int)id, new PausedPlayer((ConfigurationSection)section)));
    }

    @Override
    public void save(ConfigurationSection config) {
        for (Map.Entry<Integer, List<PausedPlayer>> entry : this.pauses.entrySet()) {
            for (PausedPlayer p : entry.getValue()) {
                p.save(config.createSection(entry.getKey() + "." + p.getPlayer()));
            }
        }
    }
}

