/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.pause;

import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PausedPlayer
implements Saveable {
    private String player;
    private ItemStack[] inv;
    private double health;
    private int food;
    private float saturation;
    private float xp;
    private int oxygen;
    private GameMode gm;
    private Location loc;
    private List<PotionEffect> effects;

    public PausedPlayer(ConfigurationSection config) {
        this.load(config);
    }

    public PausedPlayer(Player p) {
        this(p.getName(), p.getInventory(), p.getHealth(), p.getFoodLevel(), p.getSaturation(), p.getExp(), p.getRemainingAir(), p.getGameMode(), p.getLocation(), p.getActivePotionEffects());
    }

    public PausedPlayer(String pl, PlayerInventory invArg, double h, int f, float s, float xp, int oxygen, GameMode gm, Location loc, Collection<PotionEffect> e) {
        this.player = pl;
        this.health = h;
        this.food = f;
        this.saturation = s;
        this.xp = xp;
        this.oxygen = oxygen;
        this.gm = gm;
        this.loc = loc;
        this.effects = new ArrayList<PotionEffect>();
        this.effects.addAll(e);
        this.inv = new ItemStack[40];
        this.inv[0] = this.cloneIfNotNull(invArg.getHelmet());
        this.inv[1] = this.cloneIfNotNull(invArg.getChestplate());
        this.inv[2] = this.cloneIfNotNull(invArg.getLeggings());
        this.inv[3] = this.cloneIfNotNull(invArg.getBoots());
        for (int i = 0; i < 36; ++i) {
            this.inv[i + 4] = this.cloneIfNotNull(invArg.getItem(i));
        }
    }

    public boolean tryRestore() {
        Player p = Bukkit.getPlayer((String)this.player);
        if (p == null) {
            return false;
        }
        p.getInventory().setHelmet(this.inv[0]);
        p.getInventory().setChestplate(this.inv[1]);
        p.getInventory().setLeggings(this.inv[2]);
        p.getInventory().setBoots(this.inv[3]);
        for (int i = 0; i < 36; ++i) {
            p.getInventory().setItem(i, this.inv[i + 4]);
        }
        p.updateInventory();
        for (PotionEffect pe : p.getActivePotionEffects()) {
            p.removePotionEffect(pe.getType());
        }
        p.addPotionEffects(this.effects);
        p.setHealth(this.health);
        p.setFoodLevel(this.food);
        p.setSaturation(this.saturation);
        p.setExp(this.xp);
        p.setRemainingAir(this.oxygen);
        p.setGameMode(this.gm);
        p.teleport(this.loc);
        return true;
    }

    public String getPlayer() {
        return this.player;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PausedPlayer)) {
            return false;
        }
        PausedPlayer that = (PausedPlayer)o;
        return this.player.equals(that.player);
    }

    public int hashCode() {
        return this.player.hashCode();
    }

    private ItemStack cloneIfNotNull(ItemStack item) {
        return item == null ? null : item.clone();
    }

    @Override
    public void load(ConfigurationSection config) {
        this.player = config.getString("player");
        this.health = config.getDouble("health");
        this.food = config.getInt("player");
        this.saturation = (float)config.getDouble("player");
        this.xp = (float)config.getDouble("player");
        this.oxygen = config.getInt("oxygen", 300);
        this.gm = ConfigHelper.enumValueOf(GameMode.class, config.getString("gm"), GameMode.SURVIVAL);
        this.loc = ConfigHelper.getLocation(config.getConfigurationSection("loc"));
        this.effects = new ArrayList<PotionEffect>();
        if (config.isConfigurationSection("effects")) {
            for (String key : config.getConfigurationSection("effects").getKeys(false)) {
                this.effects.add(new PotionEffect(PotionEffectType.getByName((String)key), config.getInt("effects." + key + ".duration"), config.getInt("effects." + key + ".amplifier")));
            }
        }
        this.inv = new ItemStack[40];
        this.inv[0] = config.getItemStack("inv.armor.helmet");
        this.inv[1] = config.getItemStack("inv.armor.chestplate");
        this.inv[2] = config.getItemStack("inv.armor.leggings");
        this.inv[3] = config.getItemStack("inv.armor.boots");
        if (config.isConfigurationSection("inv")) {
            for (String key : config.getConfigurationSection("inv").getKeys(false)) {
                if (key.equals("armor")) continue;
                this.inv[Integer.parseInt((String)key) + 4] = config.getItemStack("inv." + key);
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("player", (Object)this.player);
        config.set("health", (Object)this.health);
        config.set("food", (Object)this.food);
        config.set("saturation", (Object)this.saturation);
        config.set("xp", (Object)this.xp);
        config.set("oxygen", (Object)this.oxygen);
        config.set("gm", (Object)this.gm.name());
        ConfigHelper.setLocation(config.createSection("loc"), this.loc);
        config.createSection("effects");
        for (PotionEffect pe : this.effects) {
            config.set("effects." + pe.getType().getName() + ".amplifier", (Object)pe.getAmplifier());
            config.set("effects." + pe.getType().getName() + ".duration", (Object)pe.getDuration());
        }
        config.set("inv.armor.helmet", (Object)this.inv[0]);
        config.set("inv.armor.chestplate", (Object)this.inv[1]);
        config.set("inv.armor.leggings", (Object)this.inv[2]);
        config.set("inv.armor.boots", (Object)this.inv[3]);
        for (int i = 0; i < 36; ++i) {
            if (this.inv[i + 4] == null) continue;
            config.set("inv." + i, (Object)this.inv[i + 4]);
        }
    }
}

