/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.players;

import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.display.notification.RegionChange;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.scoreboard.FkScoreboard;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.scoreboard.ScoreboardDisplayer;
import fr.devsylone.fallenkingdom.utils.DistanceTree;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FkPlayer
implements Saveable {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\n(?=(\u00a7.)*?[^(\u00a7.)\\n])");
    private final GlobalDisplayService displayService;
    private final String name;
    private boolean knowsSbEdit = false;
    private PlayerState state = PlayerState.INGAME;
    private RegionChange lastChange;
    private FkScoreboard board;
    private ScoreboardDisplayer sbDisplayer;
    private Location portal;
    private boolean formatted = true;
    private int kills = 0;
    private int deaths = 0;

    public FkPlayer(@NotNull String name, @NotNull GlobalDisplayService displayService) {
        this.name = name;
        this.displayService = displayService;
    }

    public String getName() {
        return this.name;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void addKill() {
        ++this.kills;
    }

    public void addDeath() {
        ++this.deaths;
    }

    public void clearDeaths() {
        this.deaths = 0;
    }

    public void clearKills() {
        this.kills = 0;
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }

    @Nullable
    public RegionChange getLastRegionChange() {
        return this.lastChange;
    }

    public void setLastChange(@Nullable RegionChange lastChange) {
        this.lastChange = lastChange;
    }

    public void sendMessage(String message) {
        this.sendMessage(message, "", null);
    }

    public void sendMessage(Messages message) {
        if (message.getMessage().isEmpty()) {
            return;
        }
        this.sendMessage(message.getMessage(), "", null);
    }

    public void sendMessage(String message, String prefix) {
        this.sendMessage(message, prefix, null);
    }

    public void sendMessage(String message, String prefix, FkSound sound) {
        Player p = Bukkit.getPlayer((String)this.name);
        if (p != null) {
            if (sound != null) {
                p.playSound(p.getLocation(), sound.key(), 1.0f, 1.0f);
            }
            String full = message.length() < 4 ? "" : Messages.PREFIX_FK.getMessage() + prefix;
            message = NEW_LINE_PATTERN.matcher("\n" + message).replaceAll("\n" + full);
            message = message.substring(1);
            p.sendMessage(message);
        }
    }

    public void updateDisplay(@NotNull Player player, PlaceHolder ... placeHolders) {
        this.displayService.update(player, this, placeHolders);
    }

    public void exitSbDisplayer() {
        if (this.sbDisplayer == null) {
            throw new FkLightException(Messages.CMD_ERROR_SCOREBOARD_NOT_EDITING);
        }
        this.setState(PlayerState.INGAME);
        this.sbDisplayer.exit();
        this.sbDisplayer = null;
    }

    public ScoreboardDisplayer getSbDisplayer() {
        if (this.sbDisplayer == null) {
            throw new FkLightException(Messages.CMD_ERROR_SCOREBOARD_NOT_EDITING);
        }
        return this.sbDisplayer;
    }

    public void newSbDisplayer() {
        if (this.sbDisplayer != null) {
            throw new FkLightException(Messages.CMD_ERROR_SCOREBOARD_ALREADY_EDITING);
        }
        this.setState(PlayerState.EDITING_SCOREBOARD);
        this.sbDisplayer = new ScoreboardDisplayer(this);
        if (Bukkit.getPlayer((String)this.name) != null) {
            this.sbDisplayer.display();
        }
    }

    public FkScoreboard getScoreboard() {
        if (this.board == null) {
            this.board = new FkScoreboard(this, Bukkit.getPlayerExact((String)this.name));
        }
        return this.board;
    }

    @Nullable
    public FkScoreboard getScoreboardIfExists() {
        return this.board;
    }

    @Deprecated
    public void recreateScoreboard() {
        this.refreshScoreboard();
    }

    public void refreshScoreboard() {
        if (this.board == null) {
            this.board = new FkScoreboard(this, Bukkit.getPlayerExact((String)this.name));
        } else {
            this.board.refreshAll();
        }
    }

    public void removeScoreboard() {
        if (this.board != null) {
            this.board.remove();
        }
        this.board = null;
    }

    @NotNull
    public GlobalDisplayService getDisplayService() {
        return this.displayService;
    }

    public Location getPortal() {
        return this.portal;
    }

    public void setPortal(Location newLoc) {
        this.portal = newLoc;
    }

    public boolean hasAlreadyLearntHowToEditTheBeautifulScoreboard() {
        return this.knowsSbEdit;
    }

    public void knowNowSbEdit() {
        this.knowsSbEdit = true;
    }

    @NotNull
    public DistanceTree<Base> getNearBases(@NotNull Player player) {
        DistanceTree<Base> nearBases = new DistanceTree<Base>(Objects.requireNonNull(player, "player is offline").getLocation());
        Team playerTeam = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
        for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
            Base base = team.getBase();
            if (base == null || !player.getWorld().equals((Object)base.getCenter().getWorld()) || team == playerTeam) continue;
            nearBases.add(base.getCenter(), base);
        }
        return nearBases;
    }

    @NotNull
    public DistanceTree<Player> getNearAllies(@NotNull Player player) {
        DistanceTree<Player> nearAllies = new DistanceTree<Player>(Objects.requireNonNull(player, "player is offline").getLocation());
        Team playerTeam = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
        for (Player worldPlayer : player.getWorld().getPlayers()) {
            if (player == worldPlayer || playerTeam != null && FkPI.getInstance().getTeamManager().getPlayerTeam(worldPlayer) != playerTeam) continue;
            nearAllies.add(worldPlayer.getLocation(), worldPlayer);
        }
        return nearAllies;
    }

    public boolean useFormattedText() {
        return this.formatted;
    }

    public void setUseFormattedText(boolean formatted) {
        this.formatted = formatted;
        Player player = Bukkit.getPlayerExact((String)this.name);
        if (player != null) {
            this.displayService.update(player, this, new PlaceHolder[0]);
        }
    }

    @Override
    public void load(ConfigurationSection config) {
        this.kills = config.getInt("Kills");
        this.deaths = config.getInt("Deaths");
        this.knowsSbEdit = config.getBoolean("KnowsSbEdit");
        if (config.isConfigurationSection("Portal")) {
            this.portal = new Location(Bukkit.getWorld((String)config.getString("Portal.World")), (double)config.getInt("Portal.X"), (double)config.getInt("Portal.Y"), (double)config.getInt("Portal.Z"));
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("Kills", (Object)this.kills);
        config.set("Deaths", (Object)this.deaths);
        config.set("KnowsSbEdit", (Object)this.knowsSbEdit);
        if (this.portal != null && this.portal.getWorld() != null) {
            config.set("Portal.World", (Object)this.portal.getWorld().getName());
            config.set("Portal.X", (Object)this.portal.getBlockX());
            config.set("Portal.Y", (Object)this.portal.getBlockY());
            config.set("Portal.Z", (Object)this.portal.getBlockZ());
        }
    }

    public static enum PlayerState {
        INGAME,
        EDITING_SCOREBOARD;

    }
}

