/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.scoreboard;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ScoreboardDisplayer {
    private final FkPlayer fkPlayer;
    private final WeakReference<Player> player;
    private final Hologram packetManager;
    private BukkitRunnable runnable;
    private final List<Integer> entities = new ArrayList<Integer>();

    public ScoreboardDisplayer(FkPlayer fkPlayer) {
        this.fkPlayer = fkPlayer;
        this.player = new WeakReference<Player>(Bukkit.getPlayer((String)fkPlayer.getName()));
        this.packetManager = Hologram.INSTANCE;
    }

    public void display() {
        Player player = (Player)this.player.get();
        if (player == null) {
            return;
        }
        Location location = player.getLocation();
        this.entities.add(this.packetManager.createFloatingText(Messages.CMD_MAP_SCOREBOARD_DISPLAYER_EDIT_LINE.getMessage(), player, location));
        this.entities.add(this.packetManager.createFloatingText("\u00a7e >>>>> /fk scoreboard setLine <<<<< ", player, location));
        this.entities.add(this.packetManager.createFloatingText(Messages.CMD_MAP_SCOREBOARD_DISPLAYER_USE_WHEEL.getMessage(), player, location));
        this.entities.add(this.packetManager.createFloatingText(Messages.CMD_MAP_SCOREBOARD_DISPLAYER_LOOK_SCOREBOARD.getMessage(), player, location));
        this.entities.add(this.packetManager.createFloatingText(Messages.CMD_MAP_SCOREBOARD_DISPLAYER_VARIABLES.getMessage(), player, location));
        for (PlaceHolder ph : PlaceHolder.values()) {
            this.entities.add(this.packetManager.createFloatingText("\u00a78" + ph.getDescription() + "        \u00a7c->\u00a7r        " + ph.getKey(), player, location));
        }
        this.entities.add(this.packetManager.createFloatingText(Messages.CMD_MAP_SCOREBOARD_DISPLAYER_LEAVE_EDIT.getMessage(), player, location));
        this.startUpdateRunnable();
        this.fkPlayer.refreshScoreboard();
    }

    public void updateLoc(Player player) {
        Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        loc.setPitch(0.0f);
        loc = this.getSight(loc, 10);
        loc.setY(loc.getY() + 0.25 * (double)((float)this.entities.size() / 2.0f) - 1.0);
        for (int entity : this.entities) {
            Hologram.INSTANCE.updateFloatingText(player, entity, loc);
            loc.add(0.0, -0.25, 0.0);
        }
    }

    private Location getSight(Location loc, int limit) {
        Location end = loc;
        Vector direction = loc.getDirection();
        for (int offset = 0; offset < limit; ++offset) {
            float off = (float)offset / 2.0f;
            Location location = loc.clone().add(direction.getX() * (double)off, direction.getY() * (double)off, direction.getZ() * (double)off);
            if (location.getBlock().getType() != Material.AIR) {
                return end;
            }
            end = location;
        }
        return end;
    }

    public void exit() {
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
        for (int id : this.entities) {
            this.packetManager.remove((Player)this.player.get(), id);
        }
        this.entities.clear();
        this.fkPlayer.setUseFormattedText(true);
        this.fkPlayer.refreshScoreboard();
    }

    public void startUpdateRunnable() {
        this.runnable = new BukkitRunnable(){
            private double lastX = 0.0;
            private double lastY = 0.0;
            private double lastZ = 0.0;
            private float lastYaw = 0.0f;
            private float lastPitch = 0.0f;

            public void run() {
                Player p = (Player)ScoreboardDisplayer.this.player.get();
                if (p == null) {
                    this.cancel();
                    return;
                }
                Location loc = p.getLocation();
                if (Double.compare(this.lastX, loc.getX()) != 0 || Double.compare(this.lastY, loc.getY()) != 0 || Double.compare(this.lastZ, loc.getZ()) != 0 || Double.compare(this.lastYaw, loc.getYaw()) != 0 || Double.compare(this.lastPitch, loc.getPitch()) != 0) {
                    this.lastX = loc.getX();
                    this.lastY = loc.getY();
                    this.lastZ = loc.getZ();
                    this.lastYaw = loc.getYaw();
                    this.lastPitch = loc.getPitch();
                    ScoreboardDisplayer.this.updateLoc(p);
                }
            }
        };
        this.runnable.runTaskTimer((Plugin)Fk.getInstance(), 5L, 3L);
    }
}

