/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.updater;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.game.Game;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.FkConfig;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fkpi.util.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class FilesUpdater {
    private ConfigurationSection getSection;
    private ConfigurationSection setSection;
    private FileConfiguration file;
    private final String lastv;

    public FilesUpdater(String lastVersion) {
        this.lastv = lastVersion;
    }

    public void update() {
        if (FilesUpdater.isGrowing(this.lastv, "2.6.0")) {
            Object key2;
            this.file = Fk.getInstance().getSaveableManager().getFileConfiguration("save.yml");
            this.setSection = this.getSection = this.file.getConfigurationSection("FkPI.RulesManager.Rules");
            this.setSection = this.getSection = this.file.getConfigurationSection("FkPI.RulesManager.Rules");
            if (!this.isSection("ChargedCreepers")) {
                this.set("ChargedCreepers", 10050001);
            }
            if (!this.isSection("PlaceBlockInCave")) {
                this.set("PlaceBlockInCave", true);
            }
            if (!this.isSection("TntJump")) {
                this.set("TntJump", true);
            }
            if (this.get("ChargedCreepers") instanceof Boolean) {
                if (this.getSection.getBoolean("ChargedCreepers")) {
                    this.set("ChargedCreepers", 10050001);
                } else {
                    this.set("ChargedCreepers", 50001);
                }
            }
            if (this.setSection.getStringList("AllowedBlocks").contains(XMaterial.OAK_SIGN.parseMaterial().name())) {
                List list = this.setSection.getStringList("AllowedBlocks");
                list.remove(XMaterial.OAK_SIGN.parseMaterial().name());
                this.set("AllowedBlocks", list);
            }
            if (!this.isSection("NetherCap")) {
                this.set("NetherCap", 1);
            }
            if (!this.isSection("EndCap")) {
                this.set("EndCap", 1);
            }
            for (Object key2 : this.setSection.getKeys(false)) {
                this.set((String)key2 + ".value", this.get((String)key2));
            }
            this.set("PlaceBlockInCave.minimumBlocks", 3);
            this.getSection = this.file.getConfigurationSection("PlayerManager");
            this.setSection = this.file.createSection("PlayerManager.Players");
            HashSet players = new HashSet();
            key2 = players.iterator();
            while (key2.hasNext()) {
                String p = (String)key2.next();
                this.set(p + ".Deaths", this.get("Deaths." + p) == null ? Integer.valueOf(0) : this.get("Deaths." + p));
                this.set(p + ".Kills", this.get("Kills." + p) == null ? Integer.valueOf(0) : this.get("Kills." + p));
                this.set(p + ".State", "INGAME");
                this.set(p + ".KnowsSbEdit", "false");
                if (!this.isSection("Portal." + p)) continue;
                this.set(p + ".Portal.World", this.get("Portal." + p + ".World"));
                this.set(p + ".Portal.X", this.get("Portal." + p + ".X"));
                this.set(p + ".Portal.Y", this.get("Portal." + p + ".Y"));
                this.set(p + ".Portal.Z", this.get("Portal." + p + ".Z"));
            }
        }
        if (FilesUpdater.isGrowing(this.lastv, "2.11.0")) {
            this.file = Fk.getInstance().getSaveableManager().getFileConfiguration("locked_chests.yml");
            this.getSection = this.file.getConfigurationSection("LockedChestsManager");
            this.file = Fk.getInstance().getSaveableManager().getFileConfiguration("save.yml");
            this.setSection = this.file.createSection("FkPI.LockedChestsManager");
            if (this.getSection != null) {
                for (Object key2 : this.getSection.getKeys(true)) {
                    this.setSection.set((String)key2, this.getSection.get((String)key2));
                }
            }
            this.setSection = this.file.createSection("FkPI.ChestsRoomsManager");
            this.set("CaptureTime", 60);
            this.set("Offset", 2);
            this.set("Enabled", Game.GameState.valueOf(this.file.getString("Game.State")).equals((Object)Game.GameState.BEFORE_STARTING));
        }
        if (FilesUpdater.isGrowing(this.lastv, "2.16.0")) {
            this.file = Fk.getInstance().getSaveableManager().getFileConfiguration("save.yml");
            this.setSection = this.getSection = this.file.getConfigurationSection("FkPI.TeamManager");
            for (String team : this.getSection.getKeys(false)) {
                this.set(team + ".Color", Color.of(team));
            }
            this.file = Fk.getInstance().getSaveableManager().getFileConfiguration("scoreboard.yml");
            List lines = this.file.getStringList("ScoreboardManager.Sidebar");
            for (int i = 0; i < lines.size(); ++i) {
                if (!((String)lines.get(i)).startsWith("Base : ")) continue;
                lines.set(i, ((String)lines.get(i)).replaceAll("Base : ", "{BASE_PORTAL}"));
                break;
            }
            this.file.set("ScoreboardManager.Sidebar", (Object)lines);
        }
        if (FilesUpdater.isGrowing(this.lastv, "2.19.0") && !Fk.getInstance().getConfig().contains("lang")) {
            Path path = new File(Fk.getInstance().getDataFolder(), "config.yml").toPath();
            try {
                Files.write(path, "\nlang: \"fr\"".getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (FilesUpdater.isGrowing(this.lastv, "2.22.0")) {
            FkConfig displayConfig = Fk.getInstance().getSaveableManager().getFileConfiguration("display.yml");
            FkConfig scoreboardConfig = Fk.getInstance().getSaveableManager().getTempFileConfiguration("scoreboard.yml");
            if (!displayConfig.fileExists() && scoreboardConfig.fileExists()) {
                scoreboardConfig.load();
                String oldClass = "ScoreboardManager";
                String newClass = GlobalDisplayService.class.getSimpleName();
                displayConfig.set(newClass + ".scoreboard.title", scoreboardConfig.get("ScoreboardManager.Name"));
                displayConfig.set(newClass + ".scoreboard.sidebar", scoreboardConfig.getStringList("ScoreboardManager.Sidebar").stream().map(PlaceHolder::removeLegacyKeys).collect(Collectors.toList()));
                displayConfig.set(newClass + ".bools", scoreboardConfig.get("ScoreboardManager.Boolean"));
                displayConfig.set(newClass + ".no-info", scoreboardConfig.get("ScoreboardManager.NoInfo"));
                displayConfig.saveSync();
            }
        }
        if (FilesUpdater.isGrowing(this.lastv, "2.24.0")) {
            FkConfig saveConfig = Fk.getInstance().getSaveableManager().getFileConfiguration("save.yml");
            ConfigurationSection rulesSection = saveConfig.getConfigurationSection("FkPI.RulesManager.Rules");
            if (rulesSection != null) {
                boolean doPauseAfterDay = rulesSection.getBoolean("DoPauseAfterDay.value");
                ConfigurationSection autoPause = rulesSection.createSection("AutoPause");
                autoPause.set("after-day", (Object)doPauseAfterDay);
                saveConfig.saveSync();
            }
            try (Stream<Path> files = Files.list(Fk.getInstance().getDataFolder().toPath().resolve("locales"));){
                Iterable iterable = files::iterator;
                for (Path path : iterable) {
                    if (path.getFileName().toString().startsWith("messages_") || !path.getFileName().toString().endsWith(".properties")) continue;
                    Files.move(path, path.getParent().resolve("messages_" + path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException ex) {
                Fk.getInstance().getLogger().log(Level.SEVERE, "Unable to add the \"messages_\" before all lang files.", ex);
            }
        }
    }

    public boolean isSection(String path) {
        return this.getSection.isConfigurationSection(path);
    }

    public boolean contains(String path) {
        return this.getSection.contains(path);
    }

    public void set(String path, Object value) {
        this.setSection.set(path, value);
    }

    public Object get(String path) {
        return this.getSection.get(path);
    }

    public static boolean isGrowing(String v1, String v2) {
        if (v1.equals(v2)) {
            return false;
        }
        String[] parsedv1 = v1.replaceAll("-[a-zA-Z]+\\d*$", "").split("\\.");
        String[] parsedv2 = v2.replaceAll("-[a-zA-Z]+\\d*$", "").split("\\.");
        for (int i = 0; i < Math.min(parsedv1.length, parsedv2.length); ++i) {
            if (parsedv1[i].equals(parsedv2[i])) continue;
            return Integer.parseInt(parsedv1[i]) < Integer.parseInt(parsedv2[i]);
        }
        if (v1.matches(Pattern.quote(v2) + "-[a-zA-Z]+\\d*")) {
            return true;
        }
        return parsedv1.length < parsedv2.length;
    }
}

