/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.updater;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.updater.GitHubAssetInfo;
import fr.devsylone.fallenkingdom.updater.GitHubReleaseInfo;
import fr.devsylone.fallenkingdom.updater.PluginVersion;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
extends BukkitRunnable {
    private static final String LATEST_RELEASE_ENDPOINT = "https://api.github.com/repos/syldium/FallenKingdom/releases/latest";
    private static final String USER_AGENT = "FallenKingdom/Updater";
    private final Fk plugin;
    private final Logger logger;
    private final PluginVersion currentVersion;
    @Nullable
    private GitHubReleaseInfo latestRelease;

    public UpdateChecker(@NotNull Fk plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.currentVersion = new PluginVersion(plugin.getDescription().getVersion());
    }

    public void run() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URI(LATEST_RELEASE_ENDPOINT).toURL().openConnection();
            connection.setRequestProperty("User-Agent", "FallenKingdom/Updater/" + this.plugin.getDescription().getVersion());
            connection.connect();
            if (connection.getResponseCode() == 500 || connection.getResponseCode() == 403) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));){
                this.latestRelease = (GitHubReleaseInfo)new Gson().fromJson((Reader)reader, GitHubReleaseInfo.class);
                this.latestRelease.pluginVersion = new PluginVersion(this.latestRelease.tagName);
                for (GitHubAssetInfo assetInfo : this.latestRelease.assets) {
                    if (!this.isVersionRelevant(assetInfo)) continue;
                    this.latestRelease.platformAsset = assetInfo;
                }
                if (this.currentVersion.compareTo(this.latestRelease.pluginVersion) >= 0) {
                    return;
                }
                this.logger.info(Messages.CONSOLE_NEW_VERSION_AVAILABLE_1.getMessage() + " " + this.latestRelease.tagName + Messages.CONSOLE_NEW_VERSION_AVAILABLE_2.getMessage() + " (" + Messages.CONSOLE_NEW_VERSION_AVAILABLE_3.getMessage() + " " + this.plugin.getDescription().getVersion() + ").");
                GitHubAssetInfo asset = this.latestRelease.platformAsset;
                boolean done = false;
                if (asset != null) {
                    this.logger.info(Messages.CONSOLE_DOWNLOADING_NEW_VERSION.getMessage());
                    done = this.plugin.updatePlugin(asset);
                }
                if (done) {
                    this.logger.info(Messages.CONSOLE_VERSION_DOWNLOADED.getMessage());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "restart"));
                } else {
                    this.logger.warning(Messages.CONSOLE_UPDATE_ERROR.getMessage());
                    this.plugin.addOnConnectWarning(Messages.CONSOLE_NEW_VERSION_AVAILABLE.getMessage());
                }
            }
            catch (JsonSyntaxException | NumberFormatException ex) {
                this.logger.log(Level.WARNING, "Failed to parse the latest version info.", ex);
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to get release info from api.github.com.", ex);
        }
        catch (URISyntaxException ex) {
            this.logger.log(Level.SEVERE, "Invalid updater URI syntax.", ex);
        }
    }

    @NotNull
    public PluginVersion getCurrentVersion() {
        return this.currentVersion;
    }

    @Nullable
    public GitHubReleaseInfo getLatestRelease() {
        return this.latestRelease;
    }

    private boolean isVersionRelevant(@NotNull GitHubAssetInfo assetInfo) {
        return true;
    }
}

