/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.FkCommandExecutor;
import fr.devsylone.fallenkingdom.utils.PluginLog;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Team;
import io.papermc.paper.ServerBuildInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class DebuggerUtils {
    private static final String USER_AGENT = "FallenKingdom/Debug";
    private static final boolean HAS_SERVER_BUILD_INFO = Version.classExists("io.papermc.paper.ServerBuildInfo");

    private DebuggerUtils() {
    }

    public static boolean debugGame(boolean send, String username) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.yml");
        PluginLog log = new PluginLog();
        log.addLine("--------------------------------------");
        log.addLine("OS : " + System.getProperty("os.name"));
        log.addLine("Java version : " + System.getProperty("java.version"));
        log.addLine(DebuggerUtils.getServerSoftwareName() + " version : " + Bukkit.getBukkitVersion() + " | " + Bukkit.getVersion());
        log.addLine("Plugin version : v" + Fk.getInstance().getDescription().getVersion());
        log.addLine("---- Commands since reload ----");
        for (Map.Entry<String, Boolean> entry : FkCommandExecutor.logs.entrySet()) {
            log.addLine("  > " + entry.getKey() + (entry.getValue() != false ? "" : "  [Error occurred]"));
        }
        log.addLine("---- Rules ----");
        for (Map.Entry<Object, Object> entry : Fk.getInstance().getFkPI().getRulesManager().getRulesList().entrySet()) {
            log.addLine("  > " + ((Rule)entry.getKey()).getName() + " : " + entry.getValue());
        }
        log.addLine("---- Game ----");
        log.addLine("  > State: " + (Object)((Object)Fk.getInstance().getGame().getState()));
        log.addLine("  > Day: " + Fk.getInstance().getGame().getDay());
        log.addLine("  > Time: " + Fk.getInstance().getGame().getTime());
        log.addLine("  > Nether: " + Fk.getInstance().getGame().isNetherEnabled());
        log.addLine("  > PvP: " + Fk.getInstance().getGame().isPvpEnabled());
        log.addLine("  > End: " + Fk.getInstance().getGame().isEndEnabled());
        log.addLine("  > Assaults: " + Fk.getInstance().getGame().isAssaultsEnabled());
        log.addLine("---- Teams ----");
        for (Team team : FkPI.getInstance().getTeamManager().getTeams()) {
            Location loc = team.getBase() == null ? null : team.getBase().getCenter();
            log.addLine("  > " + team.getName() + ": " + (loc == null ? Character.valueOf('/') : "(" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ() + ") - " + team.getBase().getRadius()) + " - " + team.getPlayers());
        }
        log.addLine("---- Chests ---");
        for (LockedChest lockedChest : Fk.getInstance().getFkPI().getLockedChestsManager().getChests()) {
            log.addLine("  > " + lockedChest.toString());
        }
        log.addLine("---- Plugins ---");
        log.addLine("  > " + Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getName).collect(Collectors.joining(", ")));
        Fk.getInstance().getLogger().info(log.getContent());
        if (!send) {
            return true;
        }
        boolean complete = false;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Fk.getInstance().getPluginFolder());){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0]) || !matcher.matches(path)) continue;
                log.addFileContent(path);
            }
            Path logs = Fk.getInstance().getRunDir().resolve("logs");
            Path latest = logs.resolve("latest.log");
            if (Files.exists(latest, new LinkOption[0])) {
                log.addFileContent(latest);
            }
            complete = true;
        }
        catch (IOException iOException) {
            Fk.getInstance().getLogger().log(Level.SEVERE, "An error occurred while reading the plugin folder", iOException);
        }
        if (complete) {
            try {
                complete = DebuggerUtils.upload(log, username);
            }
            catch (IOException | URISyntaxException exception) {
                Fk.getInstance().getLogger().log(Level.SEVERE, "Unable to upload the log", exception);
                complete = false;
            }
        }
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean upload(@NotNull PluginLog log, String username) throws IOException, URISyntaxException {
        String boundary = Long.toHexString(System.currentTimeMillis());
        URL url = new URI("https://fklogs.etrenak.ovh/new").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            String content = "--" + boundary + "\nContent-Disposition: form-data; name=\"username\"\nContent-Type: text/plain; charset=UTF-8\n\n" + username + "\n--" + boundary + "\nContent-Disposition: form-data; name=\"file\"; filename=\"log.txt\"\nContent-Type: text/plain; charset=UTF-8\n\n" + log.getContent() + "\n--" + boundary + "--";
            byte[] out = content.getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            connection.setFixedLengthStreamingMode(length);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("User-Agent", "FallenKingdom/Debug/" + Fk.getInstance().getDescription().getVersion());
            connection.connect();
            try (OutputStream os = connection.getOutputStream();){
                os.write(out);
            }
            boolean bl = connection.getResponseCode() == 200 || connection.getResponseCode() == 201;
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }

    @NotNull
    private static String getRawServerSoftwareName() {
        if (Version.classExists("io.papermc.paper.threadedregions.RegionizedServerInitEvent")) {
            return "Folia";
        }
        if (Version.classExists("com.destroystokyo.paper.PaperConfig") || Version.classExists("io.papermc.paper.configuration.Configuration")) {
            return "Paper";
        }
        if (Version.classExists("org.spigotmc.SpigotConfig")) {
            return "Spigot";
        }
        return "CraftBukkit";
    }

    @NotNull
    private static String getServerSoftwareName() {
        String deducedName = DebuggerUtils.getRawServerSoftwareName();
        if (HAS_SERVER_BUILD_INFO) {
            ServerBuildInfo buildInfo = ServerBuildInfo.buildInfo();
            if (buildInfo.brandName().equals(deducedName)) {
                return deducedName;
            }
            return deducedName + " fork (" + buildInfo.brandName() + ')';
        }
        if (Bukkit.getVersion().contains(deducedName)) {
            return deducedName;
        }
        return deducedName + " fork";
    }
}

