/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistanceTree<T>
implements Iterable<T> {
    private final Location origin;
    @Nullable
    private Node<T> root;

    public DistanceTree(@NotNull Location origin) {
        this.origin = Objects.requireNonNull(origin, "origin");
    }

    public boolean add(@NotNull Location location, @NotNull T located) {
        int comparison;
        int distance = (int)this.origin.distanceSquared(location);
        if (this.root == null) {
            this.root = new Node<T>(distance, located);
            return true;
        }
        Node<T> node = this.root;
        while ((comparison = Integer.compare(distance, node.key)) != 0) {
            switch (comparison) {
                case -1: {
                    if (node.left == null) {
                        node.left = new Node<T>(distance, located);
                        return true;
                    }
                    node = node.left;
                    break;
                }
                case 1: {
                    if (node.right == null) {
                        node.right = new Node<T>(distance, located);
                        return true;
                    }
                    node = node.right;
                }
            }
        }
        return false;
    }

    @NotNull
    public @NotNull Optional<@NotNull T> find(int index) {
        if (index < 0 || this.root == null) {
            return Optional.empty();
        }
        return this.root.get(index, new MutableInt(-1));
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.size();
    }

    @Nullable
    public T nearest() {
        if (this.root == null) {
            return null;
        }
        Node<T> node = this.root;
        while (node.left != null) {
            node = node.left;
        }
        return node.value;
    }

    @Nullable
    public T farthest() {
        if (this.root == null) {
            return null;
        }
        Node<T> node = this.root;
        while (node.right != null) {
            node = node.right;
        }
        return node.value;
    }

    @NotNull
    public List<T> toList() {
        if (this.root == null) {
            return new ArrayList(0);
        }
        ArrayList list = new ArrayList();
        this.root.visitInfix(list);
        return list;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (this.root == null) {
            return Collections.emptyIterator();
        }
        return this.toList().iterator();
    }

    static class Node<T> {
        final int key;
        final T value;
        @Nullable
        Node<T> left;
        @Nullable
        Node<T> right;

        Node(int key, T value) {
            this.key = key;
            this.value = value;
        }

        int size() {
            int l = 0;
            int r = 0;
            if (this.left != null) {
                l = this.left.size();
            }
            if (this.right != null) {
                r = this.right.size();
            }
            return 1 + l + r;
        }

        void visitInfix(@NotNull List<T> list) {
            if (this.left != null) {
                this.left.visitInfix(list);
            }
            list.add(this.value);
            if (this.right != null) {
                this.right.visitInfix(list);
            }
        }

        @NotNull
        @NotNull Optional<@NotNull T> get(int index, @NotNull MutableInt current) {
            Optional<T> value;
            if (this.left != null && (value = this.left.get(index, current)).isPresent()) {
                return value;
            }
            if (index == current.incrementAndGet()) {
                return Optional.of(this.value);
            }
            if (this.right != null) {
                value = this.right.get(index, current);
                return value;
            }
            return Optional.empty();
        }
    }

    static class MutableInt {
        private int value;

        MutableInt(int value) {
            this.value = value;
        }

        int incrementAndGet() {
            return ++this.value;
        }
    }
}

