/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import fr.devsylone.fallenkingdom.utils.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FkConfig
extends YamlConfiguration {
    private static final Logger LOGGER = Logger.getLogger("FK");
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final AtomicInteger pendingDiskWrites = new AtomicInteger(0);
    private final File configFile;

    public FkConfig(@NotNull File configFile) {
        this.configFile = configFile;
    }

    public void load() {
        if (!this.configFile.getParentFile().exists() && !this.configFile.getParentFile().mkdirs()) {
            LOGGER.log(Level.SEVERE, Messages.CONSOLE_UNABLE_TO_CREATE_PARENT_FOLDER.getMessage());
        }
        if (!this.configFile.exists()) {
            try {
                if (!this.configFile.createNewFile()) {
                    LOGGER.log(Level.SEVERE, Messages.CONSOLE_CANNOT_WRITE.getMessage() + " " + this.configFile + ".");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Messages.CONSOLE_CANNOT_WRITE.getMessage() + " " + this.configFile + ".", e);
            }
        }
        try {
            super.load(this.configFile);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Messages.CONSOLE_CANNOT_LOAD.getMessage() + " " + this.configFile + ".", e);
        }
        catch (InvalidConfigurationException e) {
            LOGGER.log(Level.SEVERE, Messages.CONSOLE_CANNOT_READ.getMessage() + " " + this.configFile + ".", e);
        }
    }

    public boolean delete() {
        return this.configFile.delete();
    }

    public void delayedSave() {
        String data = this.saveToString();
        if (!data.isEmpty()) {
            this.pendingDiskWrites.incrementAndGet();
            EXECUTOR_SERVICE.submit(new FileWrite(this.configFile, data, this.pendingDiskWrites));
        }
    }

    public void saveSync() {
        try {
            this.save(this.configFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Unable to write the configuration file.", ex);
        }
    }

    public boolean fileExists() {
        return this.configFile.isFile();
    }

    public static synchronized void awaitSaveEnd() {
        EXECUTOR_SERVICE.shutdown();
        try {
            if (!EXECUTOR_SERVICE.awaitTermination(5L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static final class FileWrite
    implements Runnable {
        private final File file;
        private final String serialized;
        private final AtomicInteger pendingDiskWrites;

        private FileWrite(File file, String serialized, AtomicInteger pendingDiskWrites) {
            this.file = file;
            this.serialized = serialized;
            this.pendingDiskWrites = pendingDiskWrites;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = this.file;
            synchronized (file) {
                if (this.pendingDiskWrites.get() > 1) {
                    this.pendingDiskWrites.decrementAndGet();
                    return;
                }
                try {
                    block25: {
                        File parent = this.file.getCanonicalFile().getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            LOGGER.log(Level.SEVERE, Messages.CONSOLE_UNABLE_TO_CREATE_PARENT_FOLDER.getMessage());
                        }
                        if (!this.file.exists()) {
                            try {
                                if (this.file.createNewFile()) break block25;
                                LOGGER.log(Level.SEVERE, Messages.CONSOLE_FAILED_TO_CREATE_FILE.getMessage() + " " + this.file);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, Messages.CONSOLE_FAILED_TO_CREATE_FILE.getMessage() + " " + this.file, ex);
                                return;
                            }
                            return;
                        }
                    }
                    try (FileOutputStream fos = new FileOutputStream(this.file);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                        writer.write(this.serialized);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.pendingDiskWrites.decrementAndGet();
                }
            }
        }
    }
}

