/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Bukkit;

public class NMSUtils {
    private static final String SERVER_VERSION = NMSUtils.getServerVersion();
    private static final Set<Class<?>> classes = new HashSet();
    public static final String OBC_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    public static final String NMS_PACKAGE = "net.minecraft.server";
    public static final String NM_PACKAGE = "net.minecraft";
    private static final boolean NMS_REPACKAGED = NMSUtils.optionalClass("net.minecraft.network.protocol.Packet").isPresent();

    private static String getServerVersion() {
        Class server = Bukkit.getServer().getClass();
        if (!server.getSimpleName().equals("CraftServer")) {
            return "";
        }
        if (server.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            return "";
        }
        String version = server.getName().substring("org.bukkit.craftbukkit.".length());
        return version.substring(0, version.length() - ".CraftServer".length());
    }

    @Deprecated
    public static void register(String clazz) throws ClassNotFoundException {
        if (!(clazz = clazz.replaceAll("_version_", SERVER_VERSION)).contains("$")) {
            classes.add(Class.forName(clazz));
        } else {
            try {
                classes.add(Class.forName(clazz));
            }
            catch (ClassNotFoundException e) {
                String[] splitted = clazz.split("\\.");
                String packageS = "";
                for (int i = 0; i < splitted.length - 1; ++i) {
                    packageS = packageS + "." + splitted[i];
                }
                if (!packageS.isEmpty()) {
                    packageS = packageS.substring(1);
                }
                String className = clazz.split("\\$")[1];
                classes.add(Class.forName(packageS + "." + className));
            }
        }
    }

    @Deprecated
    public static Class<?> getClass(String givenName) throws ClassNotFoundException {
        boolean composedName = givenName.contains("$");
        for (Class<?> c : classes) {
            String name = c.getName();
            String simpleName = c.getSimpleName();
            if (!(!composedName ? givenName.equalsIgnoreCase(simpleName) : name.endsWith("." + givenName))) continue;
            return c;
        }
        throw new ClassNotFoundException("Cannot found this class : " + givenName + "(Is it registered ?)");
    }

    public static boolean isRepackaged() {
        return NMS_REPACKAGED;
    }

    public static String nmsClassName(String className) {
        return "net.minecraft.server." + SERVER_VERSION + '.' + className;
    }

    public static String nmsClassName(String post1_17package, String className) {
        if (NMS_REPACKAGED) {
            String classPackage = post1_17package == null ? NM_PACKAGE : "net.minecraft." + post1_17package;
            return classPackage + '.' + className;
        }
        return NMSUtils.nmsClassName(className);
    }

    @Deprecated
    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(NMSUtils.nmsClassName(className));
    }

    public static Class<?> nmsClass(String post1_17package, String className) throws ClassNotFoundException {
        return Class.forName(NMSUtils.nmsClassName(post1_17package, className));
    }

    public static Class<?> nmsClass(String post1_17package, String spigotClass, String mojangClass) throws ClassNotFoundException {
        try {
            return NMSUtils.nmsClass(post1_17package, spigotClass);
        }
        catch (ClassNotFoundException ex) {
            return NMSUtils.nmsClass(post1_17package, mojangClass);
        }
    }

    public static Optional<Class<?>> nmsOptionalClass(String className) {
        return NMSUtils.optionalClass(NMSUtils.nmsClassName(className));
    }

    public static Optional<Class<?>> nmsOptionalClass(String post1_17package, String className) {
        return NMSUtils.optionalClass(NMSUtils.nmsClassName(post1_17package, className));
    }

    public static Optional<Class<?>> nmsOptionalClass(String post1_17package, String spigotClass, String mojangClass) {
        Optional<Class<?>> spigot = NMSUtils.nmsOptionalClass(post1_17package, spigotClass);
        if (spigot.isPresent()) {
            return spigot;
        }
        return NMSUtils.nmsOptionalClass(post1_17package, mojangClass);
    }

    public static String obcClassName(String className) {
        return OBC_PACKAGE + '.' + className;
    }

    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(NMSUtils.obcClassName(className));
    }

    public static Optional<Class<?>> obcOptionalClass(String className) {
        return NMSUtils.optionalClass(NMSUtils.obcClassName(className));
    }

    public static Optional<Class<?>> optionalClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName) {
        return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName, int enumFallbackOrdinal) {
        try {
            return NMSUtils.enumValueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > enumFallbackOrdinal) {
                return constants[enumFallbackOrdinal];
            }
            throw e;
        }
    }

    public static Field getField(Class<?> holder, Class<?> fieldType, Predicate<Field> fieldPredicate) throws NoSuchFieldException {
        for (Field field : holder.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(fieldType) || !fieldPredicate.test(field)) continue;
            field.setAccessible(true);
            return field;
        }
        throw new NoSuchFieldException("On " + holder.getCanonicalName());
    }

    public static Method getMethod(Class<?> holder, Class<?> returnType, Class<?> ... parametersTypes) throws NoSuchMethodException {
        for (Method method : holder.getDeclaredMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), parametersTypes) || !method.getReturnType().isAssignableFrom(returnType)) continue;
            return method;
        }
        throw new NoSuchMethodException("On " + holder.getCanonicalName());
    }
}

