/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PluginLog {
    private static final Pattern IPV4_PATTERN = Pattern.compile("((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}");
    private static final Pattern IPV6_PATTERN = Pattern.compile("(?<!([0-9]|-|\\w))(?:[0-9a-f]{0,4}:){7}[0-9a-f]{0,4}(?!([0-9]|-|\\w))", 2);
    private StringBuilder content;

    public PluginLog() {
        this.content = new StringBuilder();
    }

    public PluginLog(@NotNull String content) {
        this.content = new StringBuilder(content);
    }

    public void addFileContent(Path path) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            this.content.append('\n');
            this.content.append('\n');
            this.content.append('\n');
            this.content.append("----------------------------------------------------------\n");
            this.content.append("           ").append(path.getFileName()).append('\n');
            this.content.append("----------------------------------------------------------\n");
            this.content.append(reader.lines().collect(Collectors.joining("\n")));
        }
    }

    @NotNull
    public static String anonymize(@NotNull String content) {
        PluginLog log = new PluginLog(content);
        log.filter();
        return log.content.toString();
    }

    private void filter() {
        this.filterIPv4();
        this.filterIPv6();
    }

    private void filterIPv4() {
        Matcher matcher = IPV4_PATTERN.matcher(this.content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "**.**.**.**");
        }
        matcher.appendTail(sb);
        this.content = new StringBuilder(sb);
    }

    private void filterIPv6() {
        Matcher matcher = IPV6_PATTERN.matcher(this.content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "****:****:****:****:****:****:****:****");
        }
        matcher.appendTail(sb);
        this.content = new StringBuilder(sb);
    }

    public String getContent() {
        this.filter();
        return this.content.toString();
    }

    public void addLine(String line) {
        this.content.append(line);
        this.content.append('\n');
    }
}

