/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.utils.XItemStack;
import fr.devsylone.fallenkingdom.version.Version;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.inventory.ItemStack;

public class PotionUtils {
    private static final Constructor<?> TILE_BREWING_STAND;
    private static final Method TILE_BREWING_STAND_SET_ITEM;
    private static final Method TILE_BREWING_STAND_GET_ITEM;
    private static final Method POTION_BREW;
    private static final Method GET_BREWING_REGISTRY;

    public static ItemStack[] getBrewedPotions(ItemStack[] potions, ItemStack ingredient) {
        try {
            if (TILE_BREWING_STAND == null) {
                Object registry = GET_BREWING_REGISTRY == null ? null : GET_BREWING_REGISTRY.invoke(PacketUtils.getNMSServer(), new Object[0]);
                ItemStack[] result = new ItemStack[potions.length];
                for (int slot = 0; slot < potions.length; ++slot) {
                    Object craftPotion = XItemStack.asCraftItem(potions[slot]);
                    Object craftIngredient = XItemStack.asCraftItem(ingredient);
                    result[slot] = XItemStack.asBukkitItem(POTION_BREW.invoke(registry, craftIngredient, craftPotion));
                }
                return result;
            }
            Object fakeTileEntityStand = TILE_BREWING_STAND.newInstance(new Object[0]);
            for (int slot = 0; slot < potions.length; ++slot) {
                if (potions[slot] == null) continue;
                TILE_BREWING_STAND_SET_ITEM.invoke(fakeTileEntityStand, slot, XItemStack.asCraftItem(potions[slot]));
            }
            TILE_BREWING_STAND_SET_ITEM.invoke(fakeTileEntityStand, 3, XItemStack.asCraftItem(ingredient));
            POTION_BREW.invoke(fakeTileEntityStand, new Object[0]);
            ItemStack[] result = new ItemStack[potions.length];
            for (int slot = 0; slot < potions.length; ++slot) {
                result[slot] = XItemStack.asBukkitItem(TILE_BREWING_STAND_GET_ITEM.invoke(fakeTileEntityStand, slot));
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        block5: {
            try {
                if (Version.VersionType.V1_9_V1_12.isHigherOrEqual()) {
                    TILE_BREWING_STAND = null;
                    TILE_BREWING_STAND_SET_ITEM = null;
                    TILE_BREWING_STAND_GET_ITEM = null;
                    Class<?> brewingRegistry = NMSUtils.nmsClass("world.item.alchemy", "PotionBrewing", "PotionBrewer");
                    POTION_BREW = NMSUtils.getMethod(brewingRegistry, XItemStack.ITEM_STACK, XItemStack.ITEM_STACK, XItemStack.ITEM_STACK);
                    Method getBrewingRegistry = null;
                    try {
                        getBrewingRegistry = NMSUtils.getMethod(PacketUtils.MINECRAFT_SERVER, brewingRegistry, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    GET_BREWING_REGISTRY = getBrewingRegistry;
                    break block5;
                }
                Class<?> tileEntityBrewingStand = NMSUtils.nmsClass("world.level.block.entity", "TileEntityBrewingStand");
                TILE_BREWING_STAND = tileEntityBrewingStand.getConstructor(new Class[0]);
                TILE_BREWING_STAND_SET_ITEM = tileEntityBrewingStand.getMethod("setItem", Integer.TYPE, XItemStack.ITEM_STACK);
                TILE_BREWING_STAND_GET_ITEM = tileEntityBrewingStand.getMethod("getItem", Integer.TYPE);
                POTION_BREW = tileEntityBrewingStand.getDeclaredMethod("o", new Class[0]);
                POTION_BREW.setAccessible(true);
                GET_BREWING_REGISTRY = null;
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

