/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import fr.devsylone.fallenkingdom.utils.KeyHelper;
import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class XAdvancement {
    private static final Class<Enum> ACHIEVEMENT;
    private static final Method HAS_ACHIEVEMENT;

    public static boolean isAdvancement() {
        return ACHIEVEMENT == null;
    }

    public static Object[] getAchievements() {
        return Objects.requireNonNull(ACHIEVEMENT, "Unable to get achievements since 1.12.").getEnumConstants();
    }

    public static boolean exist(String name) {
        try {
            if (XAdvancement.isAdvancement()) {
                return Bukkit.getServer().getAdvancement(KeyHelper.parseKey(name)) != null;
            }
            Enum.valueOf(ACHIEVEMENT, name.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean hasAdvancement(Player player, String name) {
        if (XAdvancement.isAdvancement()) {
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)KeyHelper.parseKey(name));
            Objects.requireNonNull(advancement, "The success " + name + " does not exist.");
            return player.getAdvancementProgress(advancement).isDone();
        }
        Enum achievement = Enum.valueOf(ACHIEVEMENT, name.toUpperCase());
        try {
            return (Boolean)HAS_ACHIEVEMENT.invoke((Object)player, achievement);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static Iterator<String> iterator() {
        return ACHIEVEMENT == null ? new AdvancementIterator(Bukkit.getServer().advancementIterator()) : new AchievementIterator(ACHIEVEMENT);
    }

    public static ItemStack getAchievementIcon(Object achievement) {
        String name = achievement.toString().toLowerCase().replace("_", " ");
        name = name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
        for (String word : ChatColor.stripColor((String)name).toLowerCase().split(" ")) {
            if (word.charAt(word.length() - 1) == 's') {
                word = word.substring(0, word.length() - 1);
            }
            if (word.length() < 3) continue;
            for (Material material : Material.values()) {
                for (String n : material.name().split("_")) {
                    if (!n.equalsIgnoreCase(word)) continue;
                    return XAdvancement.build(material, name, achievement.toString());
                }
            }
            for (Material material : EntityType.values()) {
                if (!material.name().equalsIgnoreCase(word)) continue;
                ItemStack skull = new ItemStack(XMaterial.PLAYER_HEAD.parseItem());
                SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
                skullMeta.setOwner("MHF_" + word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1));
                skull.setItemMeta((ItemMeta)skullMeta);
                return XAdvancement.build(skull, name, achievement.toString());
            }
        }
        return XAdvancement.build(Material.GOLD_INGOT, name, achievement.toString());
    }

    private static ItemStack build(Material material, String displayName, String lore) {
        return XAdvancement.build(new ItemStack(material), displayName, lore);
    }

    private static ItemStack build(ItemStack itemStack, String displayName, String lore) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(ChatColor.GREEN + displayName);
        meta.setLore(Collections.singletonList(ChatColor.RESET.toString() + ChatColor.GRAY + lore));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    static {
        Optional<Class<?>> achievement = NMSUtils.optionalClass("org.bukkit.Achievement");
        if (achievement.isPresent() && achievement.get().getAnnotations().length < 1) {
            ACHIEVEMENT = achievement.get();
            try {
                HAS_ACHIEVEMENT = Player.class.getDeclaredMethod("hasAchievement", ACHIEVEMENT);
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
        } else {
            ACHIEVEMENT = null;
            HAS_ACHIEVEMENT = null;
        }
    }

    static class AdvancementIterator
    implements Iterator<String> {
        private final Iterator<Advancement> iterator;

        AdvancementIterator(Iterator<Advancement> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().getKey().toString();
        }
    }

    static class AchievementIterator
    implements Iterator<String> {
        private final Class<Enum> achievementEnum;
        private int pos = 0;

        AchievementIterator(Class<Enum> achievementEnum) {
            this.achievementEnum = achievementEnum;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.achievementEnum.getEnumConstants().length;
        }

        @Override
        public String next() {
            return this.achievementEnum.getEnumConstants()[this.pos++].name().toLowerCase();
        }
    }
}

