/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import fr.devsylone.fallenkingdom.utils.XMaterial;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;

public final class XBlock {
    private static final boolean ISFLAT = XMaterial.supports(13);
    public static final Set<Material> REPLACEABLE = XBlock.materialSet(XMaterial.DANDELION, XMaterial.POPPY, XMaterial.BLUE_ORCHID, XMaterial.ALLIUM, XMaterial.AZURE_BLUET, XMaterial.RED_TULIP, XMaterial.ORANGE_TULIP, XMaterial.WHITE_TULIP, XMaterial.PINK_TULIP, XMaterial.OXEYE_DAISY, XMaterial.CORNFLOWER, XMaterial.LILY_OF_THE_VALLEY, XMaterial.WITHER_ROSE, XMaterial.SUNFLOWER, XMaterial.LILAC, XMaterial.ROSE_BUSH, XMaterial.PEONY, XMaterial.TALL_GRASS, XMaterial.LARGE_FERN, XMaterial.FERN, XMaterial.DEAD_BUSH, XMaterial.OAK_FENCE, XMaterial.AIR);
    public static final Set<Material> BLOCKS_IN_CAVES = XBlock.materialSet(XMaterial.STONE, XMaterial.GRANITE, XMaterial.DIORITE, XMaterial.ANDESITE, XMaterial.DEEPSLATE, XMaterial.DRIPSTONE_BLOCK, XMaterial.CALCITE, XMaterial.SMOOTH_BASALT, XMaterial.TUFF);
    public static final Set<Material> CONTAINERS = XBlock.materialSet(XMaterial.CHEST, XMaterial.TRAPPED_CHEST, XMaterial.BARREL);

    public static boolean isReplaceable(Block block) {
        if (ISFLAT) {
            try {
                return block.isPassable();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return REPLACEABLE.contains(block.getType());
    }

    public static boolean isBlockInCave(Material material) {
        if (ISFLAT) {
            return BLOCKS_IN_CAVES.contains(material);
        }
        return material == Material.STONE;
    }

    public static boolean canBePartOfChestRoom(Material material) {
        return CONTAINERS.contains(material);
    }

    public static boolean setColor(Block block, DyeColor color) {
        if (ISFLAT) {
            String type = block.getType().name();
            if (type.endsWith("WOOL")) {
                block.setType(Material.valueOf((String)(color.name() + "_WOOL")));
            } else if (type.endsWith("BED")) {
                block.setType(Material.valueOf((String)(color.name() + "_BED")));
            } else if (type.endsWith("STAINED_GLASS")) {
                block.setType(Material.valueOf((String)(color.name() + "_STAINED_GLASS")));
            } else if (type.endsWith("STAINED_GLASS_PANE")) {
                block.setType(Material.valueOf((String)(color.name() + "_STAINED_GLASS_PANE")));
            } else if (type.endsWith("TERRACOTTA")) {
                block.setType(Material.valueOf((String)(color.name() + "_TERRACOTTA")));
            } else if (type.endsWith("GLAZED_TERRACOTTA")) {
                block.setType(Material.valueOf((String)(color.name() + "_GLAZED_TERRACOTTA")));
            } else if (type.endsWith("BANNER")) {
                block.setType(Material.valueOf((String)(color.name() + "_BANNER")));
            } else if (type.endsWith("WALL_BANNER")) {
                block.setType(Material.valueOf((String)(color.name() + "_WALL_BANNER")));
            } else if (type.endsWith("CARPET")) {
                block.setType(Material.valueOf((String)(color.name() + "_CARPET")));
            } else if (type.endsWith("SHULKER_BOX")) {
                block.setType(Material.valueOf((String)(color.name() + "_SHULKERBOX")));
            } else if (type.endsWith("CONCRETE")) {
                block.setType(Material.valueOf((String)(color.name() + "_CONCRETE")));
            } else if (type.endsWith("CONCRETE_POWDER")) {
                block.setType(Material.valueOf((String)(color.name() + "_CONCRETE_POWDER")));
            } else {
                return false;
            }
            return true;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Colorable) {
            ((Colorable)data).setColor(color);
            state.update(true);
            return true;
        }
        return false;
    }

    public static boolean setData(Block block, byte data) {
        if (ISFLAT) {
            return false;
        }
        try {
            Method setDataMethod = Block.class.getMethod("setData", Byte.TYPE);
            setDataMethod.invoke((Object)block, data);
            return true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return false;
        }
    }

    public static Block getAirBlock(List<Block> blocks) {
        for (Block block : blocks) {
            Material material = block.getType();
            if (material != Material.AIR && material != XMaterial.CAVE_AIR.parseMaterial()) continue;
            return block;
        }
        return null;
    }

    public static boolean isFlat() {
        return ISFLAT;
    }

    public static Set<Material> materialSet(XMaterial ... materials) {
        return XBlock.materialSet(Arrays.stream(materials));
    }

    private static Set<Material> materialSet(Stream<XMaterial> stream) {
        return stream.map(XMaterial::parseMaterial).filter(Objects::nonNull).collect(Collectors.toCollection(() -> Material.class.isEnum() ? EnumSet.noneOf(Material.class) : new HashSet()));
    }
}

