/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.utils;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.version.tracker.ChatMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XItemStack {
    private static final Method CHAT_COMPONENT_FROM_JSON;
    private static final Method CHAT_COMPONENT_TO_JSON;
    private static final Object EMPTY_REGISTRY;
    public static final Class<?> ITEM_STACK;
    private static final Method AS_NMS_COPY;
    private static final Method AS_CRAFT_MIRROR;
    private static final Field DISPLAY_NAME;
    private static final Field LORE;
    private static final Field SKULL_META_PROFILE;
    @Nullable
    private static final Constructor<?> RESOLVABLE_PROFILE_CONSTRUCTOR;
    private static final boolean HAS_COMPONENT_API;
    private static final boolean SERIALIZED_VIEW;

    @NotNull
    public static ItemStack setDisplayNameAndLore(@NotNull ItemStack itemStack, @NotNull BaseComponent[] displayName, @NotNull @NotNull List<@NotNull BaseComponent[]> lore) throws InvocationTargetException, IllegalAccessException {
        ItemMeta meta = itemStack.getItemMeta();
        if (HAS_COMPONENT_API) {
            meta.setDisplayNameComponent(displayName);
            meta.setLoreComponents(lore);
        } else {
            String jsonDisplayName = ComponentSerializer.toString((BaseComponent[])displayName);
            Stream<String> jsonLore = lore.stream().map(ComponentSerializer::toString);
            DISPLAY_NAME.set(meta, SERIALIZED_VIEW ? jsonDisplayName : CHAT_COMPONENT_FROM_JSON.invoke(null, jsonDisplayName));
            LORE.set(meta, SERIALIZED_VIEW ? jsonLore.collect(Collectors.toList()) : jsonLore.map(json -> {
                try {
                    return CHAT_COMPONENT_FROM_JSON.invoke(null, json);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList()));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static Object asCraftItem(ItemStack itemStack) {
        try {
            return AS_NMS_COPY.invoke(null, itemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack asBukkitItem(Object nmsItemStack) {
        if (nmsItemStack == null) {
            return null;
        }
        if (!ITEM_STACK.isAssignableFrom(nmsItemStack.getClass())) {
            throw new IllegalArgumentException("Can't convert " + nmsItemStack + " to bukkit item stack.");
        }
        try {
            return (ItemStack)AS_CRAFT_MIRROR.invoke(null, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseComponent[] getTextComponent(Object obj, int count) throws ReflectiveOperationException {
        int i = 0;
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.getType().equals(ChatMessage.CHAT_BASE_COMPONENT) || i++ != count) continue;
            field.setAccessible(true);
            String json = EMPTY_REGISTRY != null ? (String)CHAT_COMPONENT_TO_JSON.invoke(null, field.get(obj), EMPTY_REGISTRY) : (String)CHAT_COMPONENT_TO_JSON.invoke(null, field.get(obj));
            return ComponentSerializer.parse((String)json);
        }
        throw new RuntimeException("Text component field not found");
    }

    @Contract(value="_, _ -> param1")
    @NotNull
    public static SkullMeta applyBase64Texture(@NotNull SkullMeta meta, @NotNull String texture) {
        if (SKULL_META_PROFILE == null) {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"");
            profile.setProperty(new ProfileProperty("textures", texture));
            meta.setPlayerProfile(profile);
        } else {
            GameProfile profile = new GameProfile(UUID.randomUUID(), "");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            try {
                if (RESOLVABLE_PROFILE_CONSTRUCTOR != null) {
                    SKULL_META_PROFILE.set(meta, RESOLVABLE_PROFILE_CONSTRUCTOR.newInstance(profile));
                } else {
                    SKULL_META_PROFILE.set(meta, profile);
                }
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return meta;
    }

    static {
        try {
            boolean hasComponentApi;
            Class<?> chatSerializer = NMSUtils.nmsOptionalClass("network.chat", "IChatBaseComponent$ChatSerializer", "Component$Serializer").orElse(null);
            if (chatSerializer == null) {
                chatSerializer = NMSUtils.obcClass("util.CraftChatMessage");
            }
            Optional<Class<?>> registryAccess = NMSUtils.nmsOptionalClass("core", "IRegistryCustom", "RegistryAccess");
            Optional<Method> parseFromJson = Arrays.stream(chatSerializer.getDeclaredMethods()).filter(m -> ChatMessage.CHAT_BASE_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> Arrays.equals(m.getParameterTypes(), new Class[]{String.class})).findFirst();
            if (parseFromJson.isPresent()) {
                CHAT_COMPONENT_FROM_JSON = parseFromJson.get();
                CHAT_COMPONENT_TO_JSON = Arrays.stream(chatSerializer.getDeclaredMethods()).filter(m -> m.getReturnType().equals(String.class)).filter(m -> Arrays.equals(m.getParameterTypes(), new Class[]{ChatMessage.CHAT_BASE_COMPONENT})).findAny().orElseThrow(RuntimeException::new);
                EMPTY_REGISTRY = null;
            } else {
                CHAT_COMPONENT_FROM_JSON = Arrays.stream(chatSerializer.getDeclaredMethods()).filter(m -> ChatMessage.CHAT_BASE_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> {
                    Class<?>[] params = m.getParameterTypes();
                    return params.length == 2 && params[0].equals(String.class) && params[1].isAssignableFrom((Class)registryAccess.get());
                }).findAny().orElseThrow(RuntimeException::new);
                CHAT_COMPONENT_TO_JSON = Arrays.stream(chatSerializer.getDeclaredMethods()).filter(m -> m.getReturnType().equals(String.class)).filter(m -> {
                    Class<?>[] params = m.getParameterTypes();
                    return params.length == 2 && params[0].equals(ChatMessage.CHAT_BASE_COMPONENT) && params[1].isAssignableFrom((Class)registryAccess.get());
                }).findAny().orElseThrow(RuntimeException::new);
                EMPTY_REGISTRY = Arrays.stream(registryAccess.get().getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && ((Class)registryAccess.get()).isAssignableFrom(field.getType())).findAny().orElseThrow(RuntimeException::new).get(null);
            }
            ITEM_STACK = NMSUtils.nmsClass("world.item", "ItemStack");
            AS_NMS_COPY = NMSUtils.obcClass("inventory.CraftItemStack").getDeclaredMethod("asNMSCopy", ItemStack.class);
            AS_CRAFT_MIRROR = NMSUtils.obcClass("inventory.CraftItemStack").getDeclaredMethod("asCraftMirror", ITEM_STACK);
            try {
                ItemMeta.class.getMethod("setDisplayNameComponent", BaseComponent[].class);
                hasComponentApi = true;
            }
            catch (NoSuchMethodException e) {
                hasComponentApi = false;
            }
            HAS_COMPONENT_API = hasComponentApi;
            Field skullMetaProfile = null;
            try {
                Class.forName("com.destroystokyo.paper.profile.PlayerProfile");
                Player.class.getMethod("setPlayerProfile", PlayerProfile.class);
            }
            catch (ReflectiveOperationException e) {
                skullMetaProfile = NMSUtils.obcClass("inventory.CraftMetaSkull").getDeclaredField("profile");
                skullMetaProfile.setAccessible(true);
            }
            SKULL_META_PROFILE = skullMetaProfile;
            Constructor<?> resolvableProfileConstructor = null;
            try {
                if (skullMetaProfile != null) {
                    resolvableProfileConstructor = skullMetaProfile.getType().getConstructor(GameProfile.class);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            RESOLVABLE_PROFILE_CONSTRUCTOR = resolvableProfileConstructor;
            Class<?> craftMeta = NMSUtils.obcClass("inventory.CraftMetaItem");
            DISPLAY_NAME = craftMeta.getDeclaredField("displayName");
            DISPLAY_NAME.setAccessible(true);
            LORE = craftMeta.getDeclaredField("lore");
            LORE.setAccessible(true);
            SERIALIZED_VIEW = String.class.equals(DISPLAY_NAME.getType());
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

