/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version;

import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.AdventureFormat;
import fr.devsylone.fkpi.teams.Team;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Environment {
    private static final boolean HAS_ASYNC_TELEPORT;
    private static final boolean HAS_MULTI_BLOCK_CHANGE;
    private static final boolean HAS_UUID_BY_PLAYER_NAME;
    private static final boolean HAS_ASYNC_CHUNK_LOAD;
    private static final boolean HAS_ADVENTURE_API;
    private static final boolean HAS_MIN_HEIGHT;
    private static final boolean HAS_SPIGOT_BOOK_PAGES;
    private static final boolean HAS_DIRECT_INVENTORY_HOLDER;
    private static final boolean HAS_ENCHANTMENT_GLINT_OVERRIDE;
    private static final boolean HAS_ENTITY_BY_UUID;
    public static final boolean HAS_DATA_COMPONENTS;

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        if (HAS_ASYNC_TELEPORT) {
            return entity.teleportAsync(location);
        }
        return CompletableFuture.completedFuture(entity.teleport(location));
    }

    public static UUID getPlayerUniqueId(String playerName) {
        if (HAS_UUID_BY_PLAYER_NAME) {
            return Bukkit.getPlayerUniqueId((String)playerName);
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        return player == null ? null : player.getUniqueId();
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z) {
        if (HAS_ASYNC_CHUNK_LOAD) {
            return world.getChunkAtAsync(x, z);
        }
        return CompletableFuture.completedFuture(world.getChunkAt(x, z));
    }

    public static void setDeathMessage(PlayerDeathEvent event, Team playerTeam, Team killerTeam) {
        if (HAS_ADVENTURE_API) {
            AdventureFormat.setDeathMessage(event, playerTeam, killerTeam);
            return;
        }
        String deathMessage = event.getDeathMessage();
        if (deathMessage == null) {
            return;
        }
        deathMessage = Messages.PREFIX_FK.getMessage() + deathMessage;
        if (playerTeam != null) {
            deathMessage = deathMessage.replace(event.getEntity().getName(), event.getEntity().getDisplayName() + ChatColor.GRAY);
        }
        if (event.getEntity().getKiller() != null && killerTeam != null) {
            deathMessage = deathMessage.replace(event.getEntity().getKiller().getName(), event.getEntity().getKiller().getDisplayName() + ChatColor.GRAY);
        }
        event.setDeathMessage(deathMessage);
    }

    public static int getMinHeight(World world) {
        return HAS_MIN_HEIGHT ? world.getMinHeight() : 0;
    }

    public static boolean hasMultiBlockChange() {
        return HAS_MULTI_BLOCK_CHANGE;
    }

    public static boolean hasSpigotBookPages() {
        return HAS_SPIGOT_BOOK_PAGES;
    }

    @Nullable
    public static InventoryHolder getInventoryHolder(@NotNull Inventory inventory) {
        if (HAS_DIRECT_INVENTORY_HOLDER) {
            return inventory.getHolder(false);
        }
        return inventory.getHolder();
    }

    public static void setEnchantmentGlintOverride(@NotNull ItemMeta itemMeta, boolean overrideGlint) {
        if (HAS_ENCHANTMENT_GLINT_OVERRIDE) {
            itemMeta.setEnchantmentGlintOverride(overrideGlint ? Boolean.valueOf(true) : null);
            return;
        }
        if (overrideGlint) {
            itemMeta.addEnchant(Enchantment.LURE, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            itemMeta.removeEnchant(Enchantment.LURE);
            itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
    }

    @Nullable
    public static Entity getEntityByUuid(@NotNull World world, @NotNull UUID uuid) {
        if (HAS_ENTITY_BY_UUID) {
            return world.getEntity(uuid);
        }
        for (Entity entity : world.getEntities()) {
            if (!entity.getUniqueId().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    static {
        boolean hasAsyncTeleport = false;
        try {
            Entity.class.getMethod("teleportAsync", Location.class);
            hasAsyncTeleport = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_ASYNC_TELEPORT = hasAsyncTeleport;
        boolean hasMultiBlockChange = false;
        try {
            Player.class.getDeclaredMethod("sendMultiBlockChange", Map.class);
            hasMultiBlockChange = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_MULTI_BLOCK_CHANGE = hasMultiBlockChange;
        boolean hasUuidByPlayerName = false;
        try {
            Bukkit.class.getMethod("getPlayerUniqueId", String.class);
            hasUuidByPlayerName = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_UUID_BY_PLAYER_NAME = hasUuidByPlayerName;
        boolean hasAsyncChunkLoad = false;
        try {
            World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
            hasAsyncChunkLoad = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_ASYNC_CHUNK_LOAD = hasAsyncChunkLoad;
        boolean hasAdventureApi = false;
        try {
            Class<?> component = Class.forName("net.kyori.adventure.text.Component");
            PlayerDeathEvent.class.getMethod("deathMessage", component);
            hasAdventureApi = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException component) {
            // empty catch block
        }
        HAS_ADVENTURE_API = hasAdventureApi;
        boolean hasMinHeight = false;
        try {
            World.class.getMethod("getMinHeight", new Class[0]);
            hasMinHeight = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_MIN_HEIGHT = hasMinHeight;
        boolean spigotPages = false;
        try {
            Class.forName(BookMeta.class.getName() + "$Spigot").getMethod("setPages", List.class);
            spigotPages = true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        HAS_SPIGOT_BOOK_PAGES = spigotPages;
        boolean hasDirectInventoryHolder = false;
        try {
            Inventory.class.getMethod("getHolder", Boolean.TYPE);
            hasDirectInventoryHolder = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_DIRECT_INVENTORY_HOLDER = hasDirectInventoryHolder;
        boolean hasEnchantmentGlintOverride = false;
        try {
            ItemMeta.class.getMethod("setEnchantmentGlintOverride", Boolean.class);
            hasEnchantmentGlintOverride = true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        HAS_ENCHANTMENT_GLINT_OVERRIDE = hasEnchantmentGlintOverride;
        boolean hasEntityByUuid = false;
        try {
            World.class.getMethod("getEntity", UUID.class);
            hasEntityByUuid = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_ENTITY_BY_UUID = hasEntityByUuid;
        boolean hasDataComponents = false;
        try {
            Class<?> valuedClass = Class.forName("io.papermc.paper.datacomponent.DataComponentType$Valued");
            ItemStack.class.getMethod("setData", valuedClass, Object.class);
            hasDataComponents = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        HAS_DATA_COMPONENTS = hasDataComponents;
    }
}

