/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version;

import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XBlock;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fallenkingdom.version.Environment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeLocationSearcher {
    private static final Set<Material> DAMAGING_TYPES = XBlock.materialSet(XMaterial.CACTUS, XMaterial.CAMPFIRE, XMaterial.FIRE, XMaterial.MAGMA_BLOCK, XMaterial.SOUL_CAMPFIRE, XMaterial.SOUL_FIRE, XMaterial.SWEET_BERRY_BUSH, XMaterial.WITHER_ROSE, XMaterial.POINTED_DRIPSTONE, XMaterial.POWDER_SNOW, XMaterial.LAVA_CAULDRON);
    private final Location around;

    public SafeLocationSearcher(@NotNull Location around) {
        Objects.requireNonNull(around, "Destination not set.");
        Objects.requireNonNull(around.getWorld(), "Destination world not set.");
        this.around = around;
    }

    @NotNull
    public @NotNull CompletableFuture<@NotNull Location> find(int radius) {
        HashMap<Long, List> chunks = new HashMap<Long, List>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int x = this.around.getBlockX() + dx;
                int z = this.around.getBlockZ() + dz;
                long chunkKey = SafeLocationSearcher.chunkKey(x >> 4, z >> 4);
                Block2DPos pos = new Block2DPos(x & 0xF, z & 0xF);
                chunks.computeIfAbsent(chunkKey, s -> new ArrayList()).add(pos);
            }
        }
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        for (Map.Entry entry : chunks.entrySet()) {
            this.check(this.around, (Long)entry.getKey(), (List)entry.getValue(), future, radius);
        }
        future.completeExceptionally(new LocationNotFound());
        return future;
    }

    private void check(Location base, long chunkKey, List<Block2DPos> positions, CompletableFuture<Location> future, int radius) {
        if (future.isCancelled() || future.isDone() || future.isCompletedExceptionally()) {
            return;
        }
        World world = this.around.getWorld();
        ((CompletableFuture)Environment.getChunkAtAsync(world, (int)chunkKey, (int)(chunkKey >> 32)).thenApply(chunk -> {
            for (Block2DPos pos : positions) {
                int downY;
                int upY = Math.min(base.getBlockY() + 3 + radius, world.getMaxHeight() - 1);
                Location loc = this.getSafeDestination((Chunk)chunk, pos.x, pos.z, upY, downY = Math.max(base.getBlockY() - 2 - radius, Environment.getMinHeight(world)));
                if (loc == null) continue;
                future.complete(loc);
                return true;
            }
            return false;
        })).exceptionally(future::completeExceptionally);
    }

    @Nullable
    private Location getSafeDestination(Chunk chunk, int x, int z, int upY, int downY) {
        int y = upY;
        Block block = chunk.getBlock(x, y, z);
        int airCount = 0;
        while (y > downY) {
            airCount = XBlock.isReplaceable(block) && !block.isLiquid() ? airCount + 1 : 0;
            block = chunk.getBlock(x, --y, z);
            Material type = block.getType();
            if (airCount <= 1 || XBlock.isReplaceable(block) || DAMAGING_TYPES.contains(type) || block.isLiquid()) continue;
            return block.getLocation().add(0.5, 1.0, 0.5);
        }
        return null;
    }

    private static long chunkKey(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    static class Block2DPos {
        final int x;
        final int z;

        Block2DPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Block2DPos)) {
                return false;
            }
            Block2DPos that = (Block2DPos)other;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return this.x & 0xF | (this.z & 0xF) << 4;
        }
    }

    public static class LocationNotFound
    extends RuntimeException {
        LocationNotFound() {
            super(Messages.PLAYER_BASE_OBSTRUCTED.getMessage());
        }
    }
}

