/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import org.bukkit.Bukkit;

public class Version {
    public static final VersionType VERSION_TYPE = Version.classExists("org.bukkit.block.data.BlockData") ? (Version.classExists("org.bukkit.event.inventory.TradeSelectEvent") ? (Version.classExists("org.bukkit.entity.Goat") ? (Version.classExists("org.bukkit.entity.Sniffer") ? VersionType.V1_20 : (Version.classExists("org.bukkit.block.SculkCatalyst") ? VersionType.V1_19 : VersionType.V1_17)) : (Version.classExists("org.bukkit.entity.Hoglin") ? VersionType.V1_16 : VersionType.V1_14_V1_15)) : VersionType.V1_13) : (Bukkit.getVersion().contains("1.8") ? VersionType.V1_8 : VersionType.V1_9_V1_12);

    public static boolean hasSpigotApi() {
        return Version.classExists("org.spigotmc.SpigotConfig");
    }

    public static boolean hasPaperApi() {
        return Version.classExists("com.destroystokyo.paper.PaperConfig");
    }

    public static boolean isTooOldApi() {
        return !NMSUtils.nmsOptionalClass("IScoreboardCriteria$EnumScoreboardHealthDisplay").isPresent() && !VersionType.V1_9_V1_12.isHigherOrEqual();
    }

    public static boolean isBrigadierSupported() {
        return Version.classExists("com.mojang.brigadier.CommandDispatcher");
    }

    public static boolean isAsyncTabCompleteSupported() {
        return Version.classExists("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent");
    }

    public static boolean isAsyncPlayerSendCommandsEventSupported() {
        return Version.classExists("com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent");
    }

    public static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException notFound) {
            return false;
        }
    }

    public static enum VersionType {
        V1_8,
        V1_9_V1_12,
        V1_13,
        V1_14_V1_15,
        V1_16,
        V1_17,
        V1_19,
        V1_20;


        public boolean isHigherOrEqual() {
            return VERSION_TYPE.ordinal() >= this.ordinal();
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "1.8.3";
                }
                case 1: {
                    return "1.9.4";
                }
                case 2: {
                    return "1.13.2";
                }
                case 3: {
                    return "1.14.4";
                }
                case 4: {
                    return "1.16.5";
                }
                case 5: {
                    return "1.17.1";
                }
                case 6: {
                    return "1.19.4";
                }
                case 7: {
                    return "1.20.1";
                }
            }
            return "Unknown";
        }
    }
}

