/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.advancement;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.XItemStack;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitAdvancement {
    private static Field BUKKIT_ADVANCEMENT;
    private static Method GET_DISPLAY;
    private static Method GET_HANDLE;
    private static Method GET_PARENT;
    private static Method GET_ICON;
    private static Method GET_BUKKIT_ITEM_STACK;

    @NotNull
    private static ItemStack createIcon(@NotNull String key, @NotNull Object display) {
        try {
            BaseComponent[] name;
            for (BaseComponent baseComponent : name = XItemStack.getTextComponent(display, 0)) {
                baseComponent.setItalic(Boolean.valueOf(false));
                baseComponent.setColor(ChatColor.RESET);
            }
            ArrayList<BaseComponent[]> description = new ArrayList<BaseComponent[]>();
            TextComponent namespacedKey = new TextComponent(key);
            namespacedKey.setItalic(Boolean.valueOf(false));
            namespacedKey.setColor(ChatColor.GRAY);
            description.add(new BaseComponent[]{namespacedKey});
            BaseComponent[] desc = XItemStack.getTextComponent(display, 1);
            if (new TextComponent(desc).toPlainText().length() < 32) {
                description.add(desc);
                for (BaseComponent component : (BaseComponent[])description.get(1)) {
                    component.setItalic(Boolean.valueOf(false));
                    component.setColor(ChatColor.GREEN);
                }
            }
            Object object = GET_ICON.invoke(display, new Object[0]);
            ItemStack itemStack = (ItemStack)GET_BUKKIT_ITEM_STACK.invoke(null, object);
            XItemStack.setDisplayNameAndLore(itemStack, name, description);
            return itemStack;
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void buildAdvancements(@NotNull List<ItemStack> categories, @NotNull Map<String, List<ItemStack>> representations) {
        Iterator iterator = Bukkit.getServer().advancementIterator();
        while (iterator.hasNext()) {
            Advancement advancement = (Advancement)iterator.next();
            Object display = BukkitAdvancement.getDisplay(advancement);
            if (display == null) continue;
            Advancement root = BukkitAdvancement.getRoot(advancement);
            ItemStack icon = BukkitAdvancement.createIcon(advancement.getKey().toString(), display);
            if (advancement == root) {
                categories.add(icon);
                continue;
            }
            representations.computeIfAbsent(root.getKey().toString(), s -> new ArrayList()).add(icon);
        }
    }

    @NotNull
    private static Advancement getRoot(@NotNull Advancement advancement) {
        try {
            Object nms = GET_HANDLE.invoke((Object)advancement, new Object[0]);
            while (GET_PARENT.invoke(nms, new Object[0]) != null) {
                nms = GET_PARENT.invoke(nms, new Object[0]);
            }
            return (Advancement)BUKKIT_ADVANCEMENT.get(nms);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    private static Object getDisplay(@NotNull Advancement advancement) {
        try {
            return GET_DISPLAY.invoke(GET_HANDLE.invoke((Object)advancement, new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            GET_HANDLE = NMSUtils.obcClass("advancement.CraftAdvancement").getMethod("getHandle", new Class[0]);
            Class<?> nmsAdvancement = GET_HANDLE.getReturnType();
            GET_PARENT = NMSUtils.getMethod(nmsAdvancement, nmsAdvancement, new Class[0]);
            BUKKIT_ADVANCEMENT = NMSUtils.getField(nmsAdvancement, Advancement.class, f -> true);
            Class<?> nmsDisplay = NMSUtils.nmsClass("advancements", "AdvancementDisplay", "DisplayInfo");
            GET_DISPLAY = NMSUtils.getMethod(nmsAdvancement, nmsDisplay, new Class[0]);
            Class<?> craftItemStack = NMSUtils.obcClass("inventory.CraftItemStack");
            Class<?> nmsItemStackClass = craftItemStack.getMethod("asNMSCopy", ItemStack.class).getReturnType();
            GET_ICON = NMSUtils.getMethod(nmsDisplay, nmsItemStackClass, new Class[0]);
            GET_BUKKIT_ITEM_STACK = craftItemStack.getMethod("asBukkitCopy", nmsItemStackClass);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }
}

