/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.advancement;

import io.papermc.paper.advancement.AdvancementDisplay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PaperAdvancement {
    private static final Style GRAY_ITALIC = PaperAdvancement.notItalic((TextColor)NamedTextColor.GRAY);
    private static final Style BLUE_DARK_AQUA = PaperAdvancement.notItalic((TextColor)NamedTextColor.DARK_AQUA);
    private static final Style BLUE_ITALIC = PaperAdvancement.notItalic((TextColor)NamedTextColor.BLUE);

    @NotNull
    public static ItemStack asItemStack(@NotNull Key key, @NotNull AdvancementDisplay display) {
        ItemStack itemStack = display.icon();
        ItemMeta meta = itemStack.getItemMeta();
        meta.displayName(display.title().style(BLUE_DARK_AQUA));
        meta.lore(Arrays.asList(Component.text((String)key.asString(), (Style)GRAY_ITALIC), display.description().style(BLUE_ITALIC)));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static Style notItalic(@NotNull TextColor color) {
        return Style.style().color(color).decoration(TextDecoration.ITALIC, false).build();
    }

    public static void buildAdvancements(@NotNull List<ItemStack> categories, @NotNull Map<String, List<ItemStack>> representations) {
        Iterator iterator = Bukkit.getServer().advancementIterator();
        while (iterator.hasNext()) {
            Advancement advancement = (Advancement)iterator.next();
            AdvancementDisplay display = advancement.getDisplay();
            if (display == null) continue;
            Advancement root = advancement.getRoot();
            ItemStack icon = PaperAdvancement.asItemStack((Key)advancement.getKey(), display);
            if (advancement.getKey().equals((Object)root.getKey())) {
                categories.add(icon);
                continue;
            }
            representations.computeIfAbsent(root.getKey().toString(), s -> new ArrayList()).add(icon);
        }
    }
}

