/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.component;

import fr.devsylone.fallenkingdom.version.component.Components;
import fr.devsylone.fallenkingdom.version.component.FkBook;
import fr.devsylone.fallenkingdom.version.component.FkComponent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

class AdventureImpl
implements FkComponent {
    Component component;

    AdventureImpl(@NotNull Component component) {
        this.component = component;
    }

    AdventureImpl(String content, ChatColor ... colors) {
        this((Component)Component.text((String)content, (Style)AdventureImpl.asAdventure(colors)));
    }

    AdventureImpl(FkComponent ... components) {
        this((Component)Component.join((ComponentLike)Component.empty(), (ComponentLike[])AdventureImpl.asAdventure(components)));
    }

    @NotNull
    static FkComponent newline() {
        return new AdventureImpl((Component)Component.newline());
    }

    @NotNull
    static FkComponent space() {
        return new AdventureImpl((Component)Component.space());
    }

    @Override
    @NotNull
    public FkComponent changePage(int page) {
        this.component = this.component.clickEvent(net.kyori.adventure.text.event.ClickEvent.changePage((int)page));
        return this;
    }

    @Override
    @NotNull
    public FkComponent command(@NotNull String command) {
        this.component = this.component.clickEvent(net.kyori.adventure.text.event.ClickEvent.runCommand((String)command));
        return this;
    }

    @Override
    @NotNull
    public FkComponent interact(@NotNull ClickEvent event) {
        this.component = this.component.clickEvent(net.kyori.adventure.text.event.ClickEvent.clickEvent((ClickEvent.Action)AdventureImpl.asAdventure(event.getAction()), (String)event.getValue()));
        return this;
    }

    @Override
    @NotNull
    public FkComponent hover(@NotNull String content) {
        this.component = this.component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)content)));
        return this;
    }

    @Override
    @NotNull
    public FkComponent hover(@NotNull FkComponent component) {
        this.component = this.component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)((AdventureImpl)component).component));
        return this;
    }

    @Override
    @NotNull
    public String toLegacyText() {
        return LegacyComponentSerializer.legacySection().serialize(this.component);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AdventureImpl)) {
            return false;
        }
        AdventureImpl adventure = (AdventureImpl)o;
        return this.component.equals((Object)adventure.component);
    }

    public int hashCode() {
        return this.component.hashCode();
    }

    public String toString() {
        return this.component.toString();
    }

    @NotNull
    private static ClickEvent.Action asAdventure(ClickEvent.Action eventAction) {
        switch (eventAction) {
            case OPEN_URL: {
                return ClickEvent.Action.OPEN_URL;
            }
            case OPEN_FILE: {
                return ClickEvent.Action.OPEN_FILE;
            }
            case RUN_COMMAND: {
                return ClickEvent.Action.RUN_COMMAND;
            }
            case SUGGEST_COMMAND: {
                return ClickEvent.Action.SUGGEST_COMMAND;
            }
            case CHANGE_PAGE: {
                return ClickEvent.Action.CHANGE_PAGE;
            }
            case COPY_TO_CLIPBOARD: {
                return ClickEvent.Action.COPY_TO_CLIPBOARD;
            }
        }
        throw new IllegalArgumentException("Unknown click event.");
    }

    @NotNull
    private static Style asAdventure(ChatColor ... colors) {
        if (colors.length == 0) {
            return Style.empty();
        }
        if (colors.length == 1 && !Components.TEXT_DECORATIONS.contains(colors[0])) {
            return Style.style((TextColor)AdventureImpl.asAdventure(colors[0]));
        }
        Style.Builder style = Style.style();
        for (ChatColor color : colors) {
            if (color == ChatColor.MAGIC) {
                style.decorate(TextDecoration.OBFUSCATED);
                continue;
            }
            if (color == ChatColor.BOLD) {
                style.decorate(TextDecoration.BOLD);
                continue;
            }
            if (color == ChatColor.STRIKETHROUGH) {
                style.decorate(TextDecoration.STRIKETHROUGH);
                continue;
            }
            if (color == ChatColor.UNDERLINE) {
                style.decorate(TextDecoration.UNDERLINED);
                continue;
            }
            if (color == ChatColor.ITALIC) {
                style.decorate(TextDecoration.ITALIC);
                continue;
            }
            if (color == ChatColor.RESET) continue;
            style.color(AdventureImpl.asAdventure(color));
        }
        return style.build();
    }

    @NotNull
    private static TextColor asAdventure(ChatColor color) {
        if (color == ChatColor.BLACK) {
            return NamedTextColor.BLACK;
        }
        if (color == ChatColor.DARK_BLUE) {
            return NamedTextColor.DARK_BLUE;
        }
        if (color == ChatColor.DARK_GREEN) {
            return NamedTextColor.DARK_GREEN;
        }
        if (color == ChatColor.DARK_AQUA) {
            return NamedTextColor.DARK_AQUA;
        }
        if (color == ChatColor.DARK_RED) {
            return NamedTextColor.DARK_RED;
        }
        if (color == ChatColor.DARK_PURPLE) {
            return NamedTextColor.DARK_PURPLE;
        }
        if (color == ChatColor.GOLD) {
            return NamedTextColor.GOLD;
        }
        if (color == ChatColor.GRAY) {
            return NamedTextColor.GRAY;
        }
        if (color == ChatColor.DARK_GRAY) {
            return NamedTextColor.DARK_GRAY;
        }
        if (color == ChatColor.BLUE) {
            return NamedTextColor.BLUE;
        }
        if (color == ChatColor.GREEN) {
            return NamedTextColor.GREEN;
        }
        if (color == ChatColor.AQUA) {
            return NamedTextColor.AQUA;
        }
        if (color == ChatColor.RED) {
            return NamedTextColor.RED;
        }
        if (color == ChatColor.LIGHT_PURPLE) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        if (color == ChatColor.WHITE) {
            return NamedTextColor.WHITE;
        }
        return TextColor.color((int)color.getColor().getRGB());
    }

    @NotNull
    static Component asAdventure(FkComponent component) {
        return ((AdventureImpl)component).component;
    }

    @NotNull
    static Component[] asAdventure(FkComponent ... components) {
        return (Component[])Arrays.stream(components).map(AdventureImpl::asAdventure).toArray(Component[]::new);
    }

    static class BookImpl
    implements FkBook {
        private final Book book;
        private final FkComponent title;
        private final FkComponent author;
        private final List<FkComponent> pages;
        private ItemStack itemStack;

        BookImpl(FkComponent title, FkComponent author, FkComponent ... pages) {
            this.book = Book.book((Component)Component.empty(), (Component)AdventureImpl.asAdventure(author), (Component[])AdventureImpl.asAdventure(pages));
            this.title = title;
            this.author = author;
            this.pages = Arrays.asList(pages);
        }

        @Override
        @NotNull
        public FkComponent title() {
            return this.title;
        }

        @Override
        @NotNull
        public FkComponent author() {
            return this.author;
        }

        @Override
        @NotNull
        public List<FkComponent> pages() {
            return this.pages;
        }

        @Override
        @NotNull
        public String jsonPages() {
            return GsonComponentSerializer.gson().serializer().toJson(this.book.pages().stream().map(page -> (String)GsonComponentSerializer.gson().serialize(page)).collect(Collectors.toList()));
        }

        @Override
        @NotNull
        public ItemStack asItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(Material.WRITTEN_BOOK);
                BookMeta meta = (BookMeta)this.itemStack.getItemMeta();
                meta.title(this.book.title());
                meta.author(this.book.author());
                meta.addPages(this.book.pages().toArray(new Component[0]));
                this.itemStack.setItemMeta((ItemMeta)meta);
            }
            return this.itemStack;
        }

        @Override
        public void open(@NotNull Player player) {
            player.openBook(this.book);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BookImpl)) {
                return true;
            }
            BookImpl book1 = (BookImpl)o;
            return this.book.equals((Object)book1.book);
        }

        public int hashCode() {
            return this.book.hashCode();
        }

        public String toString() {
            return this.book.toString();
        }
    }
}

