/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.component;

import fr.devsylone.fallenkingdom.version.component.FkComponent;
import java.util.Arrays;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.NotNull;

class BungeeImpl
implements FkComponent {
    final BaseComponent component;

    BungeeImpl(BaseComponent component) {
        this.component = component;
    }

    BungeeImpl(String content, ChatColor ... colors) {
        this((BaseComponent)new TextComponent(content));
        for (ChatColor color : colors) {
            if (color == ChatColor.MAGIC) {
                this.component.setObfuscated(Boolean.valueOf(true));
                continue;
            }
            if (color == ChatColor.BOLD) {
                this.component.setBold(Boolean.valueOf(true));
                continue;
            }
            if (color == ChatColor.STRIKETHROUGH) {
                this.component.setStrikethrough(Boolean.valueOf(true));
                continue;
            }
            if (color == ChatColor.UNDERLINE) {
                this.component.setUnderlined(Boolean.valueOf(true));
                continue;
            }
            if (color == ChatColor.ITALIC) {
                this.component.setItalic(Boolean.valueOf(true));
                continue;
            }
            if (color == ChatColor.RESET) continue;
            this.component.setColor(color);
        }
    }

    BungeeImpl(FkComponent ... components) {
        this((BaseComponent)new TextComponent(BungeeImpl.asBungee(Arrays.stream(components))));
    }

    @NotNull
    static FkComponent newline() {
        return new BungeeImpl((BaseComponent)new TextComponent("\n"));
    }

    @NotNull
    static FkComponent space() {
        return new BungeeImpl((BaseComponent)new TextComponent(" "));
    }

    @Override
    @NotNull
    public FkComponent interact(@NotNull ClickEvent event) {
        this.component.setClickEvent(event);
        return this;
    }

    @Override
    @NotNull
    public FkComponent hover(@NotNull String content) {
        this.component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(content)}));
        return this;
    }

    @Override
    @NotNull
    public FkComponent hover(@NotNull FkComponent component) {
        this.component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{((BungeeImpl)component).component}));
        return this;
    }

    @Override
    @NotNull
    public String toLegacyText() {
        return this.component.toLegacyText();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BungeeImpl)) {
            return false;
        }
        BungeeImpl bungee = (BungeeImpl)o;
        return this.component.equals((Object)bungee.component);
    }

    public int hashCode() {
        return this.component.hashCode();
    }

    public String toString() {
        return this.component.toString();
    }

    @NotNull
    static BaseComponent[] asBungee(Stream<FkComponent> components) {
        return (BaseComponent[])components.map(component -> ((BungeeImpl)component).component).toArray(BaseComponent[]::new);
    }

    @NotNull
    static String toJson(FkComponent component) {
        return ComponentSerializer.toString((BaseComponent)((BungeeImpl)component).component);
    }
}

