/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.block;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.version.packet.block.BlockChange;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class NMSBlockChange
implements BlockChange {
    private static final Constructor<?> PACKET_BLOCK_CHANGE;
    private static final Method GET_BLOCK_BY_ID;

    NMSBlockChange() {
    }

    @Override
    public void send(@NotNull Player player, @NotNull Location location, @NotNull Material material) {
        try {
            Object blockPos = PacketUtils.getNMSBlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object packet = PACKET_BLOCK_CHANGE.newInstance(PacketUtils.getNMSWorld(player.getWorld()), blockPos);
            PacketUtils.setField("block", GET_BLOCK_BY_ID.invoke(null, material.getId()), packet);
            PacketUtils.sendPacket(player, packet);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            Class<?> worldClass = NMSUtils.nmsClass("world", "World");
            String packetsPackage = "network.protocol.game";
            Class<?> packetBlockChangeClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutBlockChange");
            PACKET_BLOCK_CHANGE = packetBlockChangeClass.getConstructor(worldClass, PacketUtils.MINECRAFT_BLOCK_POSITION);
            Class<?> blockClass = NMSUtils.nmsClass("world", "Block");
            GET_BLOCK_BY_ID = blockClass.getMethod("getByCombinedId", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

