/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.block;

import fr.devsylone.fallenkingdom.version.packet.block.BlockChange;
import fr.devsylone.fallenkingdom.version.packet.block.MultiBlockChange;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class NMSMultiBlockChange
implements MultiBlockChange {
    private final Set<SingleBlockChange> changes = new HashSet<SingleBlockChange>();

    NMSMultiBlockChange() {
    }

    @Override
    public void change(@NotNull Block block, @NotNull Material material) {
        this.changes.add(new SingleBlockChange(block, material));
    }

    @Override
    public void send(@NotNull Player player) {
        for (SingleBlockChange change : this.changes) {
            BlockChange.INSTANCE.send(player, change.position.getLocation(), change.material);
        }
    }

    @Override
    public void cancel(@NotNull Player player) {
        for (SingleBlockChange change : this.changes) {
            BlockChange.INSTANCE.send(player, change.position.getLocation(), change.position.getType());
        }
    }

    private static class SingleBlockChange {
        final Block position;
        final Material material;

        SingleBlockChange(@NotNull Block position, @NotNull Material material) {
            this.position = position;
            this.material = material;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SingleBlockChange)) {
                return false;
            }
            SingleBlockChange that = (SingleBlockChange)o;
            return this.position.equals((Object)that.position);
        }

        public int hashCode() {
            return this.position.hashCode();
        }
    }
}

