/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.version.packet.entity.BossBar;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class BukkitBossBar
implements BossBar {
    private final org.bukkit.boss.BossBar bar;

    BukkitBossBar(@NotNull String name, @NotNull ChatColor color) {
        this.bar = Bukkit.createBossBar((String)name, (BarColor)BukkitBossBar.as(color), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.bar.setVisible(true);
    }

    @Override
    public void addPlayer(@NotNull Player player) {
        this.bar.addPlayer(player);
    }

    @Override
    public void removePlayer(@NotNull Player player) {
        this.bar.removePlayer(player);
    }

    @Override
    public void setTitle(@NotNull String message) {
        this.bar.setTitle(message);
    }

    @Override
    public void setProgress(double progress) {
        this.bar.setProgress(progress);
    }

    @NotNull
    public @NotNull List<@NotNull Player> getPlayers() {
        return this.bar.getPlayers();
    }

    @Override
    public void removeAll() {
        this.bar.removeAll();
    }

    @NotNull
    private static BarColor as(@NotNull ChatColor color) {
        switch (color) {
            case DARK_RED: 
            case RED: {
                return BarColor.RED;
            }
            case DARK_GREEN: 
            case GREEN: {
                return BarColor.GREEN;
            }
            case AQUA: 
            case DARK_AQUA: 
            case BLUE: 
            case DARK_BLUE: {
                return BarColor.BLUE;
            }
            case LIGHT_PURPLE: {
                return BarColor.PINK;
            }
            case YELLOW: 
            case GOLD: {
                return BarColor.YELLOW;
            }
            case DARK_PURPLE: {
                return BarColor.PURPLE;
            }
        }
        return BarColor.WHITE;
    }
}

