/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

class BukkitHolograms
implements Hologram {
    private final Int2ObjectMap<UUID> entitiesUUIDById = new Int2ObjectOpenHashMap();

    BukkitHolograms() {
    }

    @Override
    public int createFloatingText(@NotNull String text, @NotNull Player p, @NotNull Location loc) {
        ArmorStand armorStand = (ArmorStand)p.getWorld().spawn(loc, ArmorStand.class, false, entity -> {
            entity.setVisible(false);
            entity.setCustomName(text);
            entity.setCustomNameVisible(true);
        });
        this.entitiesUUIDById.put(armorStand.getEntityId(), (Object)armorStand.getUniqueId());
        return armorStand.getEntityId();
    }

    @Override
    public void updateFloatingText(@NotNull Player player, int id, @NotNull Location location) {
        UUID uuid = Objects.requireNonNull((UUID)this.entitiesUUIDById.get(id), "Unknown custom entity id");
        Entity entity = Objects.requireNonNull(player.getWorld().getEntity(uuid), "entity");
        entity.teleport(location);
    }

    @Override
    public void updateFloatingText(@NotNull Player player, int id, @NotNull String line) {
        UUID uuid = Objects.requireNonNull((UUID)this.entitiesUUIDById.get(id), "Unknown custom entity id");
        Entity entity = Objects.requireNonNull(player.getWorld().getEntity(uuid), "entity");
        entity.setCustomName(line);
    }

    @Override
    public int displayItem(@NotNull ItemSlot slot, @NotNull Player p, @NotNull Location loc, @NotNull Material item) {
        ArmorStand armorStand = (ArmorStand)p.getWorld().spawn(loc, ArmorStand.class, false, entity -> {
            entity.setVisible(false);
            entity.setItem(EquipmentSlot.HAND, new ItemStack(item));
        });
        this.entitiesUUIDById.put(armorStand.getEntityId(), (Object)armorStand.getUniqueId());
        return armorStand.getEntityId();
    }

    @Override
    public void remove(@NotNull Player player, int id) {
        UUID uuid = Objects.requireNonNull((UUID)this.entitiesUUIDById.get(id), "Unknown custom entity id");
        Entity entity = Objects.requireNonNull(player.getWorld().getEntity(uuid), "entity");
        entity.remove();
    }
}

