/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

class DisplayBukkitHologram
implements Hologram {
    private final Int2ObjectMap<UUID> entitiesUUIDById = new Int2ObjectOpenHashMap();

    DisplayBukkitHologram() {
    }

    @Override
    public int createFloatingText(@NotNull String text, @NotNull Player player, @NotNull Location location) {
        TextDisplay display = (TextDisplay)player.getWorld().spawn(location, TextDisplay.class);
        display.setText(text);
        display.setBillboard(Display.Billboard.CENTER);
        this.entitiesUUIDById.put(display.getEntityId(), (Object)display.getUniqueId());
        return display.getEntityId();
    }

    @Override
    public void updateFloatingText(@NotNull Player player, int id, @NotNull Location location) {
        UUID uuid = (UUID)this.entitiesUUIDById.get(id);
        Entity entity = player.getWorld().getEntity(uuid);
        entity.teleport(location);
    }

    @Override
    public void updateFloatingText(@NotNull Player player, int id, @NotNull String line) {
        UUID uuid = (UUID)this.entitiesUUIDById.get(id);
        Entity entity = player.getWorld().getEntity(uuid);
        if (entity instanceof TextDisplay) {
            ((TextDisplay)entity).setText(line);
        } else {
            entity.setCustomName(line);
        }
    }

    @Override
    public int displayItem(@NotNull ItemSlot slot, @NotNull Player player, @NotNull Location location, @NotNull Material item) {
        ItemDisplay display = (ItemDisplay)player.getWorld().spawn(location, ItemDisplay.class, false, entity -> entity.setItemStack(new ItemStack(item)));
        this.entitiesUUIDById.put(display.getEntityId(), (Object)display.getUniqueId());
        return display.getEntityId();
    }

    @Override
    public void remove(@NotNull Player player, int id) {
        UUID uuid = (UUID)this.entitiesUUIDById.remove(id);
        Entity entity = player.getWorld().getEntity(uuid);
        if (entity != null) {
            entity.remove();
        }
    }
}

