/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.UnsafeValues;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

abstract class NMSHologram
implements Hologram {
    protected final IntSupplier entityIdSupplier;

    public NMSHologram() {
        IntSupplier supplier;
        try {
            Bukkit.getUnsafe().getClass().getDeclaredMethod("nextEntityId", new Class[0]);
            supplier = () -> ((UnsafeValues)Bukkit.getUnsafe()).nextEntityId();
        }
        catch (NoSuchMethodException e) {
            supplier = new AtomicInteger(100000)::getAndIncrement;
        }
        this.entityIdSupplier = supplier;
    }

    protected abstract int sendSpawn(Player var1, Location var2);

    protected abstract void sendMetadata(Player var1, int var2, boolean var3, String var4);

    protected abstract void sendTeleport(Player var1, int var2, Location var3);

    protected abstract void sendDestroy(Player var1, int var2);

    protected abstract void sendEquipment(Player var1, int var2, ItemSlot var3, Material var4);

    @Override
    public int createFloatingText(@NotNull String text, @NotNull Player p, @NotNull Location loc) {
        int id = this.sendSpawn(p, loc);
        this.sendMetadata(p, id, false, text);
        return id;
    }

    @Override
    public void updateFloatingText(@NotNull Player p, int id, @NotNull String line) {
        this.sendMetadata(p, id, false, line);
    }

    @Override
    public void updateFloatingText(@NotNull Player p, int id, @NotNull Location loc) {
        this.sendTeleport(p, id, loc);
    }

    @Override
    public void remove(@NotNull Player player, int id) {
        this.sendDestroy(player, id);
    }

    @Override
    public int displayItem(@NotNull ItemSlot slot, @NotNull Player p, @NotNull Location loc, @NotNull Material item) {
        int id = this.sendSpawn(p, loc.clone().add(0.0, -1.0, 0.0));
        this.sendMetadata(p, id, false, "");
        this.sendEquipment(p, id, slot, item);
        return id;
    }
}

