/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import com.mojang.datafixers.util.Pair;
import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.utils.Unsafety;
import fr.devsylone.fallenkingdom.utils.XItemStack;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import fr.devsylone.fallenkingdom.version.packet.entity.NMSHologram;
import fr.devsylone.fallenkingdom.version.packet.entity.NMSHologram1_9;
import fr.devsylone.fallenkingdom.version.tracker.DataTracker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

class NMSHologram1_17
extends NMSHologram {
    private static final Object ARMOR_STAND;
    private static final Object ZERO_VEC3D;
    private static final Constructor<?> VEC3D;
    private static final Constructor<?> PACKET_SPAWN_ENTITY;
    private static final Constructor<?> PACKET_DESTROY_ENTITY;
    private static final Constructor<?> PACKET_ENTITY_EQUIPMENT;
    @Nullable
    private static final Constructor<?> PACKET_ENTITY_METADATA_CONSTRUCTOR;
    @Nullable
    private static final Constructor<?> PACKET_ENTITY_POSITION_CONSTRUCTOR;
    @Nullable
    private static final Constructor<?> DELTA_MOVEMENT_CONSTRUCTOR;
    private static final Class<?> PACKET_ENTITY_METADATA;
    private static final Class<?> PACKET_ENTITY_POSITION;
    private static final Field[] PACKET_ENTITY_POSITION_FIELDS;
    private static final boolean PACKET_DESTROY_ENTITY_LIST;
    private static final boolean PACKET_SPAWN_ENTITY_HEAD_YAW;

    NMSHologram1_17() {
    }

    @Override
    protected int sendSpawn(Player p, Location loc) {
        int id = this.entityIdSupplier.getAsInt();
        try {
            Object packet = PACKET_SPAWN_ENTITY_HEAD_YAW ? PACKET_SPAWN_ENTITY.newInstance(id, UUID.randomUUID(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getPitch()), Float.valueOf(loc.getYaw()), ARMOR_STAND, 0, ZERO_VEC3D, 0.0) : PACKET_SPAWN_ENTITY.newInstance(id, UUID.randomUUID(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getPitch()), Float.valueOf(loc.getYaw()), ARMOR_STAND, 0, ZERO_VEC3D);
            PacketUtils.sendPacket(p, packet);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
        return id;
    }

    @Override
    protected void sendMetadata(Player p, int id, boolean visible, String customName) {
        try {
            Object packet;
            DataTracker tracker = new DataTracker().invisible().customName(customName).customNameVisible(true);
            if (PACKET_ENTITY_METADATA_CONSTRUCTOR == null) {
                packet = Unsafety.allocateInstance(PACKET_ENTITY_METADATA);
                PacketUtils.setField("a", id, packet);
                PacketUtils.setField("b", tracker.trackedValues(), packet);
            } else {
                packet = PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(id, tracker.serializedTrackedValues());
            }
            PacketUtils.sendPacket(p, packet);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void sendTeleport(Player p, int id, Location newLoc) {
        try {
            if (DELTA_MOVEMENT_CONSTRUCTOR != null && PACKET_ENTITY_POSITION_CONSTRUCTOR != null) {
                Object movement = DELTA_MOVEMENT_CONSTRUCTOR.newInstance(VEC3D.newInstance(newLoc.getX(), newLoc.getY(), newLoc.getZ()), ZERO_VEC3D, Float.valueOf(newLoc.getYaw()), Float.valueOf(newLoc.getPitch()));
                Object packet = PACKET_ENTITY_POSITION_CONSTRUCTOR.newInstance(id, movement, Collections.emptySet(), false);
                PacketUtils.sendPacket(p, packet);
                return;
            }
            Object packet = Unsafety.allocateInstance(PACKET_ENTITY_POSITION);
            PACKET_ENTITY_POSITION_FIELDS[0].set(packet, id);
            PACKET_ENTITY_POSITION_FIELDS[1].set(packet, newLoc.getX());
            PACKET_ENTITY_POSITION_FIELDS[2].set(packet, newLoc.getY());
            PACKET_ENTITY_POSITION_FIELDS[3].set(packet, newLoc.getZ());
            PacketUtils.sendPacket(p, packet);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendDestroy(Player p, int id) {
        try {
            Object packet = PACKET_DESTROY_ENTITY_LIST ? PACKET_DESTROY_ENTITY.newInstance(new Object[]{new int[]{id}}) : PACKET_DESTROY_ENTITY.newInstance(id);
            PacketUtils.sendPacket(p, packet);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendEquipment(Player p, int id, ItemSlot slot, Material material) {
        try {
            ItemStack bukkitItem = new ItemStack(material);
            Object armors = PACKET_ENTITY_EQUIPMENT.newInstance(id, Collections.singletonList(Pair.of((Object)NMSHologram1_9.getEnumItemSlot(slot), (Object)XItemStack.asCraftItem(bukkitItem))));
            PacketUtils.sendPacket(p, armors);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            Constructor<?> packetSpawnEntity;
            Constructor<?> entityDestroy;
            Class<?> entityTypesClass = NMSUtils.nmsClass("world.entity", "EntityTypes", "EntityType");
            Class<?> vec3dClass = NMSUtils.nmsClass("world.phys", "Vec3D", "Vec3");
            ARMOR_STAND = ((Optional)NMSUtils.getMethod(entityTypesClass, Optional.class, String.class).invoke(null, "armor_stand")).get();
            ZERO_VEC3D = NMSUtils.getField(vec3dClass, vec3dClass, field -> Modifier.isStatic(field.getModifiers())).get(null);
            VEC3D = vec3dClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
            String packetsPackage = "network.protocol.game";
            Class<?> packetSpawnEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutSpawnEntity", "ClientboundAddEntityPacket");
            Class<?> packetDestroyEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityDestroy", "ClientboundRemoveEntitiesPacket");
            Class<?> packetEntityEquipment = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityEquipment", "ClientboundSetEquipmentPacket");
            try {
                entityDestroy = packetDestroyEntityClass.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                entityDestroy = packetDestroyEntityClass.getConstructor(int[].class);
            }
            PACKET_DESTROY_ENTITY_LIST = entityDestroy.getParameterTypes()[0].equals(int[].class);
            try {
                packetSpawnEntity = packetSpawnEntityClass.getConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass);
            }
            catch (NoSuchMethodException e) {
                packetSpawnEntity = packetSpawnEntityClass.getConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass, Double.TYPE);
            }
            PACKET_SPAWN_ENTITY = packetSpawnEntity;
            PACKET_SPAWN_ENTITY_HEAD_YAW = packetSpawnEntity.getParameterCount() == 11;
            PACKET_DESTROY_ENTITY = entityDestroy;
            PACKET_ENTITY_EQUIPMENT = packetEntityEquipment.getConstructor(Integer.TYPE, List.class);
            PACKET_ENTITY_POSITION = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityTeleport", "ClientboundTeleportEntityPacket");
            Constructor<?> entityPositionConstructor = null;
            Constructor deltaMovementConstructor = null;
            try {
                Field[] deltaMovement = NMSUtils.nmsClass("world.entity", "PositionMoveRotation", "PositionMoveRotation");
                deltaMovementConstructor = deltaMovement.getConstructor(vec3dClass, vec3dClass, Float.TYPE, Float.TYPE);
                entityPositionConstructor = PACKET_ENTITY_POSITION.getConstructor(new Class[]{Integer.TYPE, deltaMovement, Set.class, Boolean.TYPE});
            }
            catch (ClassNotFoundException | NoSuchMethodException deltaMovement) {
                // empty catch block
            }
            PACKET_ENTITY_POSITION_CONSTRUCTOR = entityPositionConstructor;
            DELTA_MOVEMENT_CONSTRUCTOR = deltaMovementConstructor;
            PACKET_ENTITY_POSITION_FIELDS = (Field[])Arrays.stream(PACKET_ENTITY_POSITION.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new);
            PACKET_ENTITY_METADATA = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityMetadata", "ClientboundSetEntityDataPacket");
            for (Field field2 : PACKET_ENTITY_POSITION_FIELDS) {
                field2.setAccessible(true);
            }
            Constructor<?> entityMetadataConstructor = null;
            try {
                entityMetadataConstructor = PACKET_ENTITY_METADATA.getConstructor(Integer.TYPE, List.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            PACKET_ENTITY_METADATA_CONSTRUCTOR = entityMetadataConstructor;
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

