/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.utils.XItemStack;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import fr.devsylone.fallenkingdom.version.packet.entity.NMSHologram;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

class NMSHologram1_8
extends NMSHologram {
    private static final Constructor<?> PACKET_SPAWN_ENTITY;
    private static final Constructor<?> PACKET_ENTITY_POSITION;
    private static final Constructor<?> PACKET_ENTITY_METADATA;
    private static final Constructor<?> PACKET_DESTROY_ENTITY;
    private static final Constructor<?> PACKET_ENTITY_EQUIPMENT;
    private static final Constructor<?> PACKET_BLOCK_CHANGE;
    private static final Constructor<?> WATCHABLE_OBJECT;
    private static final Method WORLD_GET_BLOCK_TYPE;

    NMSHologram1_8() {
    }

    @Override
    protected int sendSpawn(Player p, Location loc) {
        if (loc == null && p != null) {
            loc = p.getLocation();
        }
        int id = this.entityIdSupplier.getAsInt();
        try {
            Object spawn = PACKET_SPAWN_ENTITY.newInstance(new Object[0]);
            PacketUtils.setField("a", id, spawn);
            PacketUtils.setField("b", (int)(loc.getX() * 32.0), spawn);
            PacketUtils.setField("c", (int)(loc.getY() * 32.0), spawn);
            PacketUtils.setField("d", (int)(loc.getZ() * 32.0), spawn);
            PacketUtils.setField("e", 0, spawn);
            PacketUtils.setField("f", 0, spawn);
            PacketUtils.setField("g", 0, spawn);
            PacketUtils.setField("h", 0, spawn);
            PacketUtils.setField("i", 0, spawn);
            PacketUtils.setField("j", 78, spawn);
            PacketUtils.setField("k", 0, spawn);
            PacketUtils.sendPacket(p, spawn);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
        return id;
    }

    @Override
    protected void sendMetadata(Player p, int id, boolean visible, String customName) {
        try {
            Object metadata = PACKET_ENTITY_METADATA.newInstance(new Object[0]);
            PacketUtils.setField("a", id, metadata);
            ArrayList datas = new ArrayList();
            if (!visible) {
                datas.add(WATCHABLE_OBJECT.newInstance(0, 0, (byte)32));
            }
            if (customName != null && !customName.isEmpty()) {
                datas.add(WATCHABLE_OBJECT.newInstance(4, 2, customName));
                datas.add(WATCHABLE_OBJECT.newInstance(0, 3, (byte)1));
            }
            PacketUtils.setField("b", datas, metadata);
            PacketUtils.sendPacket(p, metadata);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void sendTeleport(Player p, int id, Location newLoc) {
        try {
            int x = (int)(newLoc.getX() * 32.0);
            int y = (int)((newLoc.getY() - 0.6) * 32.0);
            int z = (int)(newLoc.getZ() * 32.0);
            Object tp = PACKET_ENTITY_POSITION.newInstance(id, x, y, z, (byte)0, (byte)0, true);
            PacketUtils.sendPacket(p, tp);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void sendDestroy(Player p, int id) {
        try {
            Object destroy = PACKET_DESTROY_ENTITY.newInstance(new Object[]{new int[]{id}});
            PacketUtils.sendPacket(p, destroy);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void sendEquipment(Player p, int id, ItemSlot slot, Material material) {
        try {
            Object nmsItem = XItemStack.asCraftItem(new ItemStack(material));
            Object armors = PACKET_ENTITY_EQUIPMENT.newInstance(id, this.getItemSlot(slot), nmsItem);
            PacketUtils.sendPacket(p, armors);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    private int getItemSlot(ItemSlot slot) {
        return slot.ordinal() > 0 ? slot.ordinal() - 1 : 0;
    }

    static {
        try {
            Class<?> worldClass = NMSUtils.nmsClass("world", "World");
            String packetsPackage = "network.protocol.game";
            Class<?> packetSpawnEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutSpawnEntity");
            Class<?> packetTeleportEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityTeleport");
            Class<?> packetEntityMetadataClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityMetadata");
            Class<?> packetDestroyEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityDestroy");
            Class<?> packetEntityEquipmentClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityEquipment");
            Class<?> packetBlockChangeClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutBlockChange");
            Class<?> watchableObjectClass = NMSUtils.nmsClass("network.syncher", "DataWatcher$WatchableObject");
            PACKET_SPAWN_ENTITY = packetSpawnEntityClass.getConstructor(new Class[0]);
            PACKET_ENTITY_POSITION = packetTeleportEntityClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE, Boolean.TYPE);
            PACKET_ENTITY_METADATA = packetEntityMetadataClass.getConstructor(new Class[0]);
            PACKET_DESTROY_ENTITY = packetDestroyEntityClass.getConstructor(int[].class);
            PACKET_ENTITY_EQUIPMENT = packetEntityEquipmentClass.getConstructor(Integer.TYPE, Integer.TYPE, XItemStack.ITEM_STACK);
            PACKET_BLOCK_CHANGE = packetBlockChangeClass.getConstructor(worldClass, PacketUtils.MINECRAFT_BLOCK_POSITION);
            WATCHABLE_OBJECT = watchableObjectClass.getConstructor(Integer.TYPE, Integer.TYPE, Object.class);
            WORLD_GET_BLOCK_TYPE = worldClass.getMethod("getType", PacketUtils.MINECRAFT_BLOCK_POSITION);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

