/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.packet.entity;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.version.packet.entity.BossBar;
import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WitherBossBar1_8
implements BossBar {
    private static final Constructor<?> PACKET_SPAWN_LIVING_ENTITY;
    private static final Constructor<?> PACKET_TELEPORT;
    private static final Constructor<?> PACKET_SET_METADATA;
    private static final Constructor<?> ENTITY_WITHER;
    private static final Method ENTITY_GET_BUKKIT_HANDLE;
    private static final Method ENTITY_GET_DATA_WATCHER;
    private static final Method ENTITY_SET_INVISIBLE;
    private static final Method ENTITY_SET_LOCATION;
    private static final Method DATA_WATCHER_WATCH;
    private static final int OFFSET_PITCH = 30;
    private static final int OFFSET_YAW = 0;
    private static final int OFFSET_MAGNITUDE = 40;
    private static final int INVULNERABLE_KEY = 20;
    private static final int INVULNERABLE_TICKS = 890;
    private double progress = 1.0;
    private final String name;
    @Nullable
    private Wither entity;
    private Object entityNms;
    private final Set<Player> viewers = new HashSet<Player>();

    WitherBossBar1_8(@NotNull String name) {
        this.name = name;
    }

    @Override
    public void addPlayer(@NotNull Player player) {
        if (this.entity == null) {
            this.entity = this.spawnWither(player.getLocation().getWorld(), this.name);
        }
        if (!this.viewers.add(player)) {
            return;
        }
        try {
            this.teleport(player, this.offsetPosition(player.getLocation()));
            Object packet = PACKET_SPAWN_LIVING_ENTITY.newInstance(this.entityNms);
            PacketUtils.sendPacket(player, packet);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void removePlayer(@NotNull Player player) {
        if (this.viewers.remove(player) && this.entity != null) {
            Hologram.INSTANCE.remove(player, this.entity.getEntityId());
        }
    }

    @Override
    public void setTitle(@NotNull String message) {
        if (this.entity == null) {
            return;
        }
        this.entity.setCustomName(message);
        this.syncMetadata();
    }

    @Override
    public void setProgress(double progress) {
        this.progress = progress;
        if (this.entity == null) {
            return;
        }
        this.entity.setHealth(progress * (this.entity.getMaxHealth() - (double)0.1f) + (double)0.1f);
        this.syncMetadata();
    }

    @NotNull
    public @NotNull Set<@NotNull Player> getPlayers() {
        return this.viewers;
    }

    @Override
    public void removeAll() {
        if (this.entity == null) {
            return;
        }
        for (Player viewer : this.viewers) {
            Hologram.INSTANCE.remove(viewer, this.entity.getEntityId());
        }
        this.viewers.clear();
    }

    @NotNull
    private Wither spawnWither(@NotNull World world, @NotNull String customName) {
        try {
            Object nmsWither = ENTITY_WITHER.newInstance(PacketUtils.getNMSWorld(world));
            ENTITY_SET_INVISIBLE.invoke(nmsWither, true);
            Object dataWatcher = ENTITY_GET_DATA_WATCHER.invoke(nmsWither, new Object[0]);
            DATA_WATCHER_WATCH.invoke(dataWatcher, 20, 890);
            this.entityNms = nmsWither;
            Wither wither = (Wither)ENTITY_GET_BUKKIT_HANDLE.invoke(nmsWither, new Object[0]);
            wither.setCustomName(customName);
            wither.setCustomNameVisible(true);
            wither.setHealth(this.progress * (wither.getMaxHealth() - (double)0.1f) + (double)0.1f);
            return wither;
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void teleport(@NotNull Player player, @NotNull Location loc) {
        try {
            ENTITY_SET_LOCATION.invoke(this.entityNms, loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()));
            Object packet = PACKET_TELEPORT.newInstance(this.entityNms);
            PacketUtils.sendPacket(player, packet);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void syncMetadata() {
        try {
            Object dataWatcher = ENTITY_GET_DATA_WATCHER.invoke(this.entityNms, new Object[0]);
            Object packet = PACKET_SET_METADATA.newInstance(this.entity.getEntityId(), dataWatcher, false);
            for (Player player : this.viewers) {
                PacketUtils.sendPacket(player, packet);
                this.teleport(player, this.offsetPosition(player.getLocation()));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private Location offsetPosition(@NotNull Location location) {
        location.setPitch(location.getPitch() - 30.0f);
        location.setYaw(location.getYaw() + 0.0f);
        location.add(location.getDirection().multiply(40));
        return location;
    }

    static {
        try {
            Class<?> worldClass = NMSUtils.nmsClass("world", "World");
            Class<?> entityClass = NMSUtils.nmsClass("entity", "Entity");
            Class<?> livingEntityClass = NMSUtils.nmsClass("entity", "EntityLiving");
            Class<?> dataWatcherClass = NMSUtils.nmsClass("entity", "DataWatcher");
            String packetsPackage = "network.protocol.game";
            Class<?> packetSpawnLivingEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutSpawnEntityLiving");
            Class<?> packetTeleportEntityClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityTeleport");
            Class<?> packetEntityMetadataClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutEntityMetadata");
            PACKET_SPAWN_LIVING_ENTITY = packetSpawnLivingEntityClass.getConstructor(livingEntityClass);
            PACKET_TELEPORT = packetTeleportEntityClass.getConstructor(entityClass);
            PACKET_SET_METADATA = packetEntityMetadataClass.getConstructor(Integer.TYPE, dataWatcherClass, Boolean.TYPE);
            ENTITY_WITHER = NMSUtils.nmsClass("entity", "EntityWither").getConstructor(worldClass);
            ENTITY_GET_BUKKIT_HANDLE = entityClass.getMethod("getBukkitEntity", new Class[0]);
            ENTITY_GET_DATA_WATCHER = entityClass.getMethod("getDataWatcher", new Class[0]);
            ENTITY_SET_INVISIBLE = entityClass.getMethod("setInvisible", Boolean.TYPE);
            ENTITY_SET_LOCATION = entityClass.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            DATA_WATCHER_WATCH = dataWatcherClass.getMethod("watch", Integer.TYPE, Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

