/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.title;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import fr.devsylone.fallenkingdom.version.title.TitleSender;
import fr.devsylone.fallenkingdom.version.tracker.ChatMessage;
import java.lang.reflect.Constructor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NMSTitleSender
implements TitleSender {
    private static final Constructor<?> PACKET_TITLE_TIMES;
    private static final Constructor<?> PACKET_TITLE_TEXT;
    private static final Class<?> TITLE_ACTION;

    NMSTitleSender() {
    }

    @Override
    public void sendTitle(@NotNull Player player, @NotNull String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        try {
            this.sendTimesPacket(player, fadeIn, stay, fadeOut);
            if (subtitle != null) {
                this.sendTitlePacket(player, TitlePart.SUBTITLE, subtitle);
            }
            this.sendTitlePacket(player, TitlePart.TITLE, title);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    private void sendTimesPacket(@NotNull Player player, int fadeIn, int stay, int fadeOut) throws ReflectiveOperationException {
        Object packet = PACKET_TITLE_TIMES.newInstance(fadeIn, stay, fadeOut);
        PacketUtils.sendPacket(player, packet);
    }

    private void sendTitlePacket(@NotNull Player player, @NotNull TitlePart part, @NotNull String content) throws ReflectiveOperationException {
        Object packet = PACKET_TITLE_TEXT.newInstance(TITLE_ACTION.getDeclaredField(part.name()).get(null), ChatMessage.legacyTextComponent(content));
        PacketUtils.sendPacket(player, packet);
    }

    static {
        try {
            String packetsPackage = "network.protocol.game";
            Class<?> packetTitleClass = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutTitle");
            TITLE_ACTION = NMSUtils.nmsClass("network.protocol.game", "PacketPlayOutTitle$EnumTitleAction");
            PACKET_TITLE_TIMES = packetTitleClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            PACKET_TITLE_TEXT = packetTitleClass.getConstructor(TITLE_ACTION, ChatMessage.CHAT_BASE_COMPONENT);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static enum TitlePart {
        TITLE,
        SUBTITLE;

    }
}

